/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class CompilerOptions {
    private static final CompilerContext.Key<CompilerOptions> OPTIONS_KEY = new CompilerContext.Key();
    private Map<CompilerOptionName, String> optionMap;

    public static CompilerOptions getInstance(CompilerContext context) {
        CompilerOptions options = context.get(OPTIONS_KEY);
        if (options == null) {
            options = new CompilerOptions(context);
        }
        return options;
    }

    private CompilerOptions(CompilerContext context) {
        context.put(OPTIONS_KEY, this);
        this.optionMap = new HashMap<CompilerOptionName, String>();
    }

    public String get(CompilerOptionName optionName) {
        return this.optionMap.get((Object)optionName);
    }

    public boolean isSet(CompilerOptionName optionName) {
        return this.optionMap.containsKey((Object)optionName);
    }

    public void put(CompilerOptionName optionName, String value) {
        this.optionMap.put(optionName, value);
    }

    public CompilerPhase getCompilerPhase() {
        String phaseName = this.get(CompilerOptionName.COMPILER_PHASE);
        if (phaseName == null || phaseName.isEmpty()) {
            return CompilerPhase.CODE_GEN;
        }
        return CompilerPhase.fromValue(phaseName);
    }
}

