/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.math.BigDecimal;
import java.math.MathContext;

public final class NumericLiteralSupport {
    public static final String FLOAT_DISCRIMINATOR = "f";
    public static final String DECIMAL_DISCRIMINATOR = "d";

    private NumericLiteralSupport() {
    }

    public static String stripDiscriminator(String literalValue) {
        int length = literalValue.length();
        if (length < 2) {
            return literalValue;
        }
        char lastChar = literalValue.charAt(length - 1);
        if (lastChar == 'f' || lastChar == 'F' || lastChar == 'd' || lastChar == 'D') {
            return literalValue.substring(0, length - 1);
        }
        return literalValue;
    }

    public static boolean isHexLiteral(String numericLiteral) {
        for (int i = 0; i < numericLiteral.length(); ++i) {
            char c = numericLiteral.charAt(i);
            if (c != 'p' && c != 'P') continue;
            return true;
        }
        return false;
    }

    public static boolean hasHexIndicator(String literalValue) {
        int length = literalValue.length();
        if (length < 3) {
            return false;
        }
        char firstChar = literalValue.charAt(1);
        char secondChar = literalValue.charAt(2);
        return firstChar == 'x' || secondChar == 'x' || firstChar == 'X' || secondChar == 'X';
    }

    public static BigDecimal parseBigDecimal(Object baseValue) {
        String strValue = String.valueOf(baseValue);
        if (NumericLiteralSupport.isDecimalDiscriminated(strValue)) {
            strValue = strValue.substring(0, strValue.length() - 1);
        }
        return new BigDecimal(strValue, MathContext.DECIMAL128);
    }

    public static boolean isDecimalDiscriminated(String literalValue) {
        int length = literalValue.length();
        if (length < 2) {
            return false;
        }
        char lastChar = literalValue.charAt(length - 1);
        return lastChar == 'd' || lastChar == 'D';
    }

    public static boolean isFloatDiscriminated(String literalValue) {
        int length = literalValue.length();
        if (length < 2) {
            return false;
        }
        char lastChar = literalValue.charAt(length - 1);
        return lastChar == 'f' || lastChar == 'F';
    }
}

