/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BBuiltInRefType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;

public class ResolvedTypeBuilder
implements BTypeVisitor<BType, BType> {
    private Map<String, BType> paramValueTypes;
    private Set<BType> visitedTypes;
    private boolean isInvocation;

    public BType build(BType originalType, BLangInvocation invocation) {
        this.isInvocation = invocation != null;
        this.visitedTypes = new HashSet<BType>();
        if (this.isInvocation) {
            this.createParamMap(invocation);
        }
        BType newType = originalType.accept(this, null);
        this.reset();
        return newType;
    }

    public BType build(BType originalType) {
        return this.build(originalType, null);
    }

    @Override
    public BType visit(BType originalType, BType newType) {
        return originalType;
    }

    @Override
    public BType visit(BBuiltInRefType originalType, BType newType) {
        return originalType;
    }

    @Override
    public BType visit(BAnyType originalType, BType newType) {
        return originalType;
    }

    @Override
    public BType visit(BAnydataType originalType, BType newType) {
        return originalType;
    }

    @Override
    public BType visit(BMapType originalType, BType newType) {
        BType newConstraint = originalType.constraint.accept(this, null);
        if (newConstraint == originalType.constraint) {
            return originalType;
        }
        BMapType newMType = new BMapType(originalType.tag, newConstraint, null);
        this.setFlags(newMType, originalType.flags);
        return newMType;
    }

    @Override
    public BType visit(BXMLType originalType, BType newType) {
        BType newConstraint = originalType.constraint.accept(this, null);
        if (newConstraint == originalType.constraint) {
            return originalType;
        }
        BXMLType newXMLType = new BXMLType(newConstraint, null);
        this.setFlags(newXMLType, originalType.flags);
        return newXMLType;
    }

    @Override
    public BType visit(BJSONType originalType, BType newType) {
        return originalType;
    }

    @Override
    public BType visit(BArrayType originalType, BType newType) {
        BType newElemType = originalType.eType.accept(this, null);
        if (newElemType == originalType.eType) {
            return originalType;
        }
        BArrayType newArrayType = new BArrayType(newElemType, null, originalType.size, originalType.state);
        this.setFlags(newArrayType, originalType.flags);
        return newArrayType;
    }

    @Override
    public BType visit(BObjectType originalType, BType newType) {
        return originalType;
    }

    @Override
    public BType visit(BRecordType originalType, BType newType) {
        if (!Symbols.isFlagOn(originalType.tsymbol.flags, 0x4000000L)) {
            return originalType;
        }
        LinkedHashMap<String, BField> newFields = new LinkedHashMap<String, BField>();
        for (BField field : originalType.fields.values()) {
            if (this.visitedTypes.contains(field.type)) continue;
            this.visitedTypes.add(field.type);
            BType newFType = field.type.accept(this, null);
            this.visitedTypes.remove(field.type);
            if (newFType == field.type) {
                newFields.put(field.name.value, field);
                continue;
            }
            BField newField = new BField(field.name, field.pos, field.symbol);
            newField.type = newFType;
            newFields.put(newField.name.value, newField);
        }
        BType newRestType = originalType.restFieldType.accept(this, null);
        BRecordType newRecordType = new BRecordType(null);
        newRecordType.fields = newFields;
        newRecordType.restFieldType = newRestType;
        this.setFlags(newRecordType, originalType.flags);
        return originalType;
    }

    @Override
    public BType visit(BTupleType originalType, BType newType) {
        boolean hasNewType = false;
        ArrayList<BType> members = new ArrayList<BType>();
        for (BType member : originalType.tupleTypes) {
            BType newMem = member.accept(this, null);
            members.add(newMem);
            if (newMem == member) continue;
            hasNewType = true;
        }
        BType rest = originalType.restType;
        if (rest != null && (rest = rest.accept(this, null)) != originalType.restType) {
            hasNewType = true;
        }
        if (!hasNewType) {
            return originalType;
        }
        BTupleType type = new BTupleType(null, members);
        type.restType = rest;
        this.setFlags(type, originalType.flags);
        return type;
    }

    @Override
    public BType visit(BStreamType originalType, BType newType) {
        BType newError;
        BType newConstraint = originalType.constraint.accept(this, null);
        BType bType = newError = originalType.error != null ? originalType.error.accept(this, null) : null;
        if (newConstraint == originalType.constraint && newError == originalType.error) {
            return originalType;
        }
        BStreamType type = new BStreamType(originalType.tag, newConstraint, newError, null);
        this.setFlags(type, originalType.flags);
        return type;
    }

    @Override
    public BType visit(BTableType originalType, BType newType) {
        BType newKeyTypeConstraint;
        BType newConstraint = originalType.constraint.accept(this, null);
        BType bType = newKeyTypeConstraint = originalType.keyTypeConstraint != null ? originalType.keyTypeConstraint.accept(this, null) : null;
        if (newConstraint == originalType.constraint && newKeyTypeConstraint == originalType.keyTypeConstraint) {
            return originalType;
        }
        BTableType newTableType = new BTableType(9, newConstraint, null);
        newTableType.keyTypeConstraint = newKeyTypeConstraint;
        newTableType.fieldNameList = originalType.fieldNameList;
        newTableType.constraintPos = originalType.constraintPos;
        newTableType.keyPos = originalType.keyPos;
        this.setFlags(newTableType, originalType.flags);
        return newTableType;
    }

    @Override
    public BType visit(BInvokableType originalType, BType newType) {
        boolean hasNewType = false;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        for (BType type : originalType.paramTypes) {
            BType newT = type.accept(this, null);
            paramTypes.add(newT);
            if (newT == type) continue;
            hasNewType = true;
        }
        BType rest = originalType.restType;
        if (rest != null && (rest = rest.accept(this, null)) != originalType.restType) {
            hasNewType = true;
        }
        BType retType = originalType.retType.accept(this, null);
        if (!hasNewType && retType != originalType.retType) {
            return originalType;
        }
        BInvokableType type = new BInvokableType(paramTypes, rest, retType, null);
        this.setFlags(type, originalType.flags);
        return type;
    }

    @Override
    public BType visit(BUnionType originalType, BType newType) {
        boolean hasNewType = false;
        LinkedHashSet<BType> newMemberTypes = new LinkedHashSet<BType>();
        for (BType member : originalType.getMemberTypes()) {
            BType newMember = member.accept(this, null);
            newMemberTypes.add(newMember);
            if (newMember == member) continue;
            hasNewType = true;
        }
        if (!hasNewType) {
            return originalType;
        }
        BUnionType type = BUnionType.create(null, newMemberTypes);
        this.setFlags(type, originalType.flags);
        return type;
    }

    @Override
    public BType visit(BIntersectionType originalType, BType newType) {
        BType newEffectiveType = originalType.effectiveType.accept(this, null);
        if (newEffectiveType == originalType.effectiveType) {
            return originalType;
        }
        BIntersectionType type = new BIntersectionType(null, (LinkedHashSet)originalType.getConstituentTypes(), newEffectiveType);
        this.setFlags(type, originalType.flags);
        return originalType;
    }

    @Override
    public BType visit(BErrorType originalType, BType newType) {
        BType newDetail = originalType.detailType.accept(this, null);
        if (newDetail == originalType.detailType) {
            return originalType;
        }
        BErrorType type = new BErrorType(null, newDetail);
        this.setFlags(type, originalType.flags);
        return type;
    }

    @Override
    public BType visit(BFutureType originalType, BType newType) {
        BType newConstraint = originalType.constraint.accept(this, null);
        if (newConstraint == originalType.constraint) {
            return originalType;
        }
        BFutureType newFutureType = new BFutureType(originalType.tag, newConstraint, null, originalType.workerDerivative);
        this.setFlags(newFutureType, originalType.flags);
        return newFutureType;
    }

    @Override
    public BType visit(BFiniteType originalType, BType newType) {
        return originalType;
    }

    @Override
    public BType visit(BTypedescType originalType, BType newType) {
        BType newConstraint = originalType.constraint.accept(this, null);
        if (newConstraint == originalType.constraint) {
            return originalType;
        }
        BTypedescType newTypedescType = new BTypedescType(newConstraint, null);
        this.setFlags(newTypedescType, originalType.flags);
        return newTypedescType;
    }

    @Override
    public BType visit(BParameterizedType originalType, BType newType) {
        BType type;
        String paramVarName = originalType.paramSymbol.name.value;
        if (this.isInvocation) {
            type = this.paramValueTypes.get(paramVarName);
            if (type == null) {
                return originalType.paramValueType;
            }
            if (type.tag == 27) {
                return type;
            }
            type = ((BTypedescType)type).constraint;
        } else {
            type = ((BTypedescType)originalType.paramSymbol.type).constraint;
        }
        return type;
    }

    private void createParamMap(BLangInvocation invocation) {
        this.paramValueTypes = new LinkedHashMap<String, BType>();
        BInvokableSymbol symbol = (BInvokableSymbol)invocation.symbol;
        int nArgs = invocation.requiredArgs.size();
        int nParams = symbol.params.size();
        for (int i = 0; i < nParams; ++i) {
            BVarSymbol param = symbol.params.get(i);
            if (param.defaultableParam && (i >= nArgs || invocation.requiredArgs.get(i).getKind() == NodeKind.IGNORE_EXPR)) {
                this.paramValueTypes.put(param.name.value, symbol.paramDefaultValTypes.get(param.name.value));
                continue;
            }
            this.paramValueTypes.put(param.name.value, invocation.requiredArgs.get((int)i).type);
        }
    }

    private void setFlags(BType type, long originalFlags) {
        type.flags |= originalFlags & 0xFFFFFFFFFBFFFFFFL;
    }

    private void reset() {
        this.visitedTypes = null;
        this.paramValueTypes = null;
        this.isInvocation = false;
    }
}

