/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.util;

import java.util.Set;
import org.ballerinalang.model.elements.AttachPoint;

public class AttachPoints {
    public static final int TYPE = 1;
    public static final int OBJECT = 2;
    public static final int FUNCTION = 4;
    public static final int OBJECT_METHOD = 8;
    public static final int SERVICE_REMOTE = 16;
    public static final int PARAMETER = 32;
    public static final int RETURN = 64;
    public static final int SERVICE = 128;
    public static final int FIELD = 256;
    public static final int OBJECT_FIELD = 512;
    public static final int RECORD_FIELD = 1024;
    public static final int LISTENER = 2048;
    public static final int ANNOTATION = 4096;
    public static final int EXTERNAL = 8192;
    public static final int VAR = 16384;
    public static final int CONST = 32768;
    public static final int WORKER = 65536;
    public static final int CLASS = 131072;

    public static int asMask(Set<AttachPoint.Point> attachPoints) {
        int mask = 0;
        for (AttachPoint.Point point : attachPoints) {
            switch (point) {
                case TYPE: {
                    mask |= 1;
                    break;
                }
                case OBJECT: {
                    mask |= 2;
                    break;
                }
                case FUNCTION: {
                    mask |= 4;
                    break;
                }
                case OBJECT_METHOD: {
                    mask |= 8;
                    break;
                }
                case SERVICE_REMOTE: {
                    mask |= 0x10;
                    break;
                }
                case PARAMETER: {
                    mask |= 0x20;
                    break;
                }
                case RETURN: {
                    mask |= 0x40;
                    break;
                }
                case SERVICE: {
                    mask |= 0x80;
                    break;
                }
                case FIELD: {
                    mask |= 0x100;
                    break;
                }
                case OBJECT_FIELD: {
                    mask |= 0x200;
                    break;
                }
                case RECORD_FIELD: {
                    mask |= 0x400;
                    break;
                }
                case LISTENER: {
                    mask |= 0x800;
                    break;
                }
                case ANNOTATION: {
                    mask |= 0x1000;
                    break;
                }
                case EXTERNAL: {
                    mask |= 0x2000;
                    break;
                }
                case VAR: {
                    mask |= 0x4000;
                    break;
                }
                case CONST: {
                    mask |= 0x8000;
                    break;
                }
                case WORKER: {
                    mask |= 0x10000;
                    break;
                }
                case CLASS: {
                    mask |= 0x20000;
                }
            }
        }
        return mask;
    }
}

