/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalRepositoryProvider.class);
    private Collection<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();

    public DefaultLocalRepositoryProvider() {
    }

    @Inject
    DefaultLocalRepositoryProvider(Set<LocalRepositoryManagerFactory> factories) {
        this.setLocalRepositoryManagerFactories(factories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory(LocalRepositoryManagerFactory factory) {
        this.managerFactories.add(Objects.requireNonNull(factory, "local repository manager factory cannot be null"));
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        PrioritizedComponents<LocalRepositoryManagerFactory> factories = new PrioritizedComponents<LocalRepositoryManagerFactory>(session);
        for (LocalRepositoryManagerFactory localRepositoryManagerFactory : this.managerFactories) {
            factories.add(localRepositoryManagerFactory, localRepositoryManagerFactory.getPriority());
        }
        ArrayList<NoLocalRepositoryManagerException> errors = new ArrayList<NoLocalRepositoryManagerException>();
        for (PrioritizedComponent prioritizedComponent : factories.getEnabled()) {
            try {
                LocalRepositoryManager localRepositoryManager = ((LocalRepositoryManagerFactory)prioritizedComponent.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(localRepositoryManager.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, localRepositoryManager);
                    buffer.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getBasedir());
                    LOGGER.debug(buffer.toString());
                }
                return localRepositoryManager;
            }
            catch (NoLocalRepositoryManagerException noLocalRepositoryManagerException) {
                errors.add(noLocalRepositoryManagerException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String string = "Could not obtain local repository manager for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(string, exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder.append("No local repository managers registered");
        } else {
            stringBuilder.append("Cannot access ").append(repository.getBasedir());
            stringBuilder.append(" with type ").append(repository.getContentType());
            stringBuilder.append(" using the available factories ");
            factories.list(stringBuilder);
        }
        throw new NoLocalRepositoryManagerException(repository, stringBuilder.toString(), errors.size() == 1 ? (NoLocalRepositoryManagerException)errors.get(0) : null);
    }
}

