/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.util.ArrayList;
import java.util.List;

public class ModuleStatus {
    private String name;
    private int totalTests;
    private int passed;
    private int failed;
    private int skipped;
    private List<Test> tests = new ArrayList<Test>();
    private static ModuleStatus instance = new ModuleStatus();

    public static ModuleStatus getInstance() {
        return instance;
    }

    public void addTestSummary(String testName, Status status, String failureMessage) {
        Test test = new Test(testName, status, failureMessage);
        this.tests.add(test);
        ++this.totalTests;
        if (test.status.equals((Object)Status.PASSED)) {
            ++this.passed;
        } else if (test.status.equals((Object)Status.FAILURE)) {
            ++this.failed;
        } else {
            ++this.skipped;
        }
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public static enum Status {
        PASSED("passed"),
        FAILURE("failure"),
        SKIPPED("skipped");

        private String value;

        private Status(String value) {
            this.value = value;
        }
    }

    private static class Test {
        private String name;
        private Status status;
        private String failureMessage = "";

        public Test(String name, Status status, String failureMessage) {
            this.name = name;
            this.status = status;
            this.failureMessage = failureMessage;
        }

        public String getFailureMessage() {
            return this.failureMessage;
        }

        public String getName() {
            return this.name;
        }
    }
}

