/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FutureValue;

public class TesterinaFunction {
    public Scheduler scheduler;
    private String bFunctionName;
    private Class<?> programFile;
    private List<String> groups = new ArrayList<String>();

    public TesterinaFunction(Class<?> programFile, String bFunctionName, Scheduler scheduler) {
        this.bFunctionName = bFunctionName;
        this.programFile = programFile;
        this.scheduler = scheduler;
    }

    public Object invoke() throws BallerinaException {
        return TesterinaFunction.runOnSchedule(this.programFile, this.bFunctionName, this.scheduler, new Class[]{Strand.class}, new Object[1]);
    }

    public Object invoke(Class[] types, Object[] args) {
        return TesterinaFunction.runOnSchedule(this.programFile, this.bFunctionName, this.scheduler, types, args);
    }

    public Object directInvoke(Class[] types) {
        return TesterinaFunction.run(this.programFile, this.bFunctionName, this.scheduler, types);
    }

    public String getName() {
        return this.bFunctionName;
    }

    public void setName(String name) {
        this.bFunctionName = name;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    private static Object run(Class<?> initClazz, String name, Scheduler scheduler, Class[] paramTypes) {
        String funcName = TesterinaFunction.cleanupFunctionName(name);
        try {
            Method method = initClazz.getDeclaredMethod(funcName, paramTypes);
            return method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new BallerinaException("Failed to invoke the function '" + funcName + " due to " + e.getMessage());
        }
    }

    private static Object runOnSchedule(Class<?> initClazz, String name, Scheduler scheduler, Class[] paramTypes, Object[] params) {
        String funcName = TesterinaFunction.cleanupFunctionName(name);
        try {
            Method method = initClazz.getDeclaredMethod(funcName, paramTypes);
            Function<Object[], Object> func = objects -> {
                try {
                    return method.invoke(null, objects);
                }
                catch (InvocationTargetException e) {
                    return e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new BallerinaException("Error while invoking function '" + funcName + "'", (Throwable)e);
                }
            };
            FutureValue out = scheduler.schedule(params, func, null, null, null, BTypes.typeAny);
            scheduler.start();
            Throwable t = out.panic;
            Object result = out.result;
            if (result instanceof ErrorValue) {
                throw new BallerinaException((Throwable)((ErrorValue)result));
            }
            if (result instanceof Exception) {
                throw new BallerinaException((Throwable)((Exception)result));
            }
            if (t != null) {
                throw new BallerinaException("Error while invoking function '" + funcName + "'", t.getMessage());
            }
            return out.result;
        }
        catch (NoSuchMethodException e) {
            throw new BallerinaException("Error while invoking function '" + funcName + "'\nIf you are using data providers please check if types return from data provider match test function parameter types.", (Throwable)e);
        }
    }

    private static String cleanupFunctionName(String name) {
        return name.replaceAll("[.:/<>]", "_");
    }
}

