/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BBooleanType;
import org.ballerinalang.jvm.types.BByteType;
import org.ballerinalang.jvm.types.BDecimalType;
import org.ballerinalang.jvm.types.BFloatType;
import org.ballerinalang.jvm.types.BIntegerType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStringType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BXMLType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.test.runtime.entity.Test;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.entity.TesterinaFunction;
import org.ballerinalang.test.runtime.entity.TesterinaReport;
import org.ballerinalang.test.runtime.entity.TesterinaResult;
import org.ballerinalang.test.runtime.util.TesterinaUtils;

public class BTestRunner {
    public static final String MODULE_INIT_CLASS_NAME = "___init";
    private static final String FILE_NAME_PERIOD_SEPARATOR = "$$$";
    private PrintStream errStream;
    private PrintStream outStream;
    private TesterinaReport tReport;

    public BTestRunner(PrintStream outStream, PrintStream errStream) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.tReport = new TesterinaReport(this.outStream);
    }

    public void runTest(TestSuite suite) {
        BTestRunner.validateTestSuite(suite);
        int[] testExecutionOrder = BTestRunner.checkCyclicDependencies(suite.getTests());
        List<Test> sortedTests = BTestRunner.orderTests(suite.getTests(), testExecutionOrder);
        suite.setTests(sortedTests);
        this.execute(suite);
    }

    private static List<Test> orderTests(List<Test> tests, int[] testExecutionOrder) {
        ArrayList<Test> sortedTests = new ArrayList<Test>();
        for (int idx : testExecutionOrder) {
            sortedTests.add(tests.get(idx));
        }
        return sortedTests;
    }

    private static void validateTestSuite(TestSuite suite) {
        Set<String> functionNames = suite.getTestUtilityFunctions().keySet();
        for (Test test : suite.getTests()) {
            String msg;
            if (test.getBeforeTestFunction() != null && !functionNames.contains(test.getBeforeTestFunction())) {
                msg = String.format("Cannot find the specified before function : [%s] for testerina function : [%s]", test.getBeforeTestFunction(), test.getTestName());
                throw new BallerinaException(msg);
            }
            if (test.getAfterTestFunction() != null && !functionNames.contains(test.getAfterTestFunction())) {
                msg = String.format("Cannot find the specified after function : [%s] for testerina function : [%s]", test.getAfterTestFunction(), test.getTestName());
                throw new BallerinaException(msg);
            }
            if (test.getDataProvider() != null && !functionNames.contains(test.getDataProvider())) {
                String dataProvider = test.getDataProvider();
                String message = String.format("Data provider function [%s] cannot be found.", dataProvider);
                throw new BallerinaException(message);
            }
            for (String dependsOnFn : test.getDependsOnTestFunctions()) {
                if (!functionNames.stream().noneMatch(func -> func.equals(dependsOnFn))) continue;
                throw new BallerinaException("Cannot find the specified dependsOn function : " + dependsOnFn);
            }
        }
    }

    private static int[] checkCyclicDependencies(List<Test> tests) {
        int numberOfNodes = tests.size();
        int[] indegrees = new int[numberOfNodes];
        int[] sortedElts = new int[numberOfNodes];
        ArrayList[] dependencyMatrix = new ArrayList[numberOfNodes];
        for (int i = 0; i < numberOfNodes; ++i) {
            dependencyMatrix[i] = new ArrayList();
        }
        List testNames = tests.stream().map(Test::getTestName).collect(Collectors.toList());
        int i = 0;
        for (Test test : tests) {
            if (!test.getDependsOnTestFunctions().isEmpty()) {
                for (String dependsOnFn : test.getDependsOnTestFunctions()) {
                    int idx = testNames.indexOf(dependsOnFn);
                    if (idx == -1) {
                        String message = String.format("Test [%s] depends on function [%s], but it couldn't be found.", test, dependsOnFn);
                        throw new BallerinaException(message);
                    }
                    dependencyMatrix[i].add(idx);
                }
            }
            ++i;
        }
        for (int j = 0; j < numberOfNodes; ++j) {
            ArrayList dependencies = dependencyMatrix[j];
            Iterator<String> iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                int node;
                int n = node = ((Integer)((Object)iterator.next())).intValue();
                indegrees[n] = indegrees[n] + 1;
            }
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        for (i = 0; i < numberOfNodes; ++i) {
            if (indegrees[i] != 0) continue;
            q.add(i);
        }
        int cnt = 0;
        Vector<Integer> topOrder = new Vector<Integer>();
        while (!q.isEmpty()) {
            int u = (Integer)q.poll();
            topOrder.add(u);
            Iterator idx = dependencyMatrix[u].iterator();
            while (idx.hasNext()) {
                int node;
                int n = node = ((Integer)idx.next()).intValue();
                indegrees[n] = indegrees[n] - 1;
                if (indegrees[n] != 0) continue;
                q.add(node);
            }
            ++cnt;
        }
        if (cnt != numberOfNodes) {
            String message = "Cyclic test dependency detected";
            throw new BallerinaException(message);
        }
        i = numberOfNodes - 1;
        Iterator iterator = topOrder.iterator();
        while (iterator.hasNext()) {
            int elt;
            sortedElts[i] = elt = ((Integer)iterator.next()).intValue();
            --i;
        }
        return sortedElts;
    }

    private void execute(TestSuite suite) {
        boolean hasTestablePackage;
        Class<?> initClazz;
        if (suite.getTests().size() == 0) {
            this.outStream.println("\tNo tests found\n");
            return;
        }
        AtomicBoolean shouldSkip = new AtomicBoolean();
        String packageName = suite.getPackageName();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        String initClassName = TesterinaUtils.getQualifiedClassName(suite.getOrgName(), suite.getPackageID(), MODULE_INIT_CLASS_NAME);
        try {
            initClazz = classLoader.loadClass(initClassName);
        }
        catch (Throwable e) {
            throw new BallerinaException("failed to load init class :" + initClassName);
        }
        Scheduler scheduler = new Scheduler(4, false);
        Scheduler initScheduler = new Scheduler(4, false);
        Class<?> testInitClazz = null;
        boolean bl = hasTestablePackage = !packageName.equals(".");
        if (hasTestablePackage) {
            String testClassName = TesterinaUtils.getQualifiedClassName(suite.getOrgName(), suite.getPackageID(), suite.getPackageID().replace(".", FILE_NAME_PERIOD_SEPARATOR));
            try {
                testInitClazz = classLoader.loadClass(testClassName);
            }
            catch (Throwable e) {
                throw new BallerinaException("failed to load Test init class :" + testClassName);
            }
            this.outStream.println("\t" + packageName);
        } else {
            this.outStream.println("\t" + suite.getSourceFileName());
        }
        shouldSkip.set(false);
        this.tReport.addPackageReport(packageName);
        this.tReport.setReportRequired(suite.isReportRequired());
        this.startSuite(suite, initScheduler, initClazz, testInitClazz, hasTestablePackage);
        this.executeBeforeSuiteFunctions(suite, classLoader, scheduler, shouldSkip);
        this.executeTests(suite, packageName, classLoader, scheduler, shouldSkip);
        this.executeAfterSuiteFunctions(suite, classLoader, scheduler);
        this.stopSuite(suite, scheduler, initClazz, testInitClazz, hasTestablePackage);
        this.tReport.printTestSuiteSummary(packageName);
    }

    private void executeBeforeSuiteFunctions(TestSuite suite, ClassLoader classLoader, Scheduler scheduler, AtomicBoolean shouldSkip) {
        suite.getBeforeSuiteFunctionNames().forEach(test -> {
            try {
                this.invokeTestFunction(suite, (String)test, classLoader, scheduler);
            }
            catch (Throwable e) {
                shouldSkip.set(true);
                String errorMsg = "\t[fail] " + test + " [before test suite function]:\n\t    " + this.formatErrorMessage(e);
                this.errStream.println(errorMsg);
            }
        });
    }

    private void executeTests(TestSuite suite, String packageName, ClassLoader classLoader, Scheduler scheduler, AtomicBoolean shouldSkip) {
        ArrayList failedOrSkippedTests = new ArrayList();
        suite.getTests().forEach(test -> {
            AtomicBoolean shouldSkipTest = new AtomicBoolean(false);
            this.executeBeforeEachFunction((Test)test, suite, classLoader, scheduler, shouldSkip, shouldSkipTest);
            this.executeBeforeFunction((Test)test, suite, classLoader, scheduler, shouldSkip, shouldSkipTest);
            this.executeFunction((Test)test, suite, packageName, classLoader, scheduler, shouldSkip, shouldSkipTest, failedOrSkippedTests);
            this.executeAfterFunction((Test)test, suite, classLoader, scheduler);
            this.executeAfterEachFunction((Test)test, suite, classLoader, scheduler);
        });
    }

    private void executeBeforeEachFunction(Test test, TestSuite suite, ClassLoader classLoader, Scheduler scheduler, AtomicBoolean shouldSkip, AtomicBoolean shouldSkipTest) {
        if (!shouldSkip.get() && !shouldSkipTest.get()) {
            suite.getBeforeEachFunctionNames().forEach(beforeEachTest -> {
                try {
                    this.invokeTestFunction(suite, (String)beforeEachTest, classLoader, scheduler);
                }
                catch (Throwable e) {
                    shouldSkipTest.set(true);
                    String errorMsg = String.format("\t[fail] " + beforeEachTest + " [before each test function for the test %s] :\n\t    %s", test, this.formatErrorMessage(e));
                    this.errStream.println(errorMsg);
                }
            });
        }
    }

    private void executeBeforeFunction(Test test, TestSuite suite, ClassLoader classLoader, Scheduler scheduler, AtomicBoolean shouldSkip, AtomicBoolean shouldSkipTest) {
        if (!shouldSkip.get() && !shouldSkipTest.get()) {
            try {
                if (test.getBeforeTestFunction() != null) {
                    this.invokeTestFunction(suite, test.getBeforeTestFunction(), classLoader, scheduler);
                }
            }
            catch (Throwable e) {
                shouldSkipTest.set(true);
                String errorMsg = String.format("\t[fail] " + test.getBeforeTestFunction() + " [before test function for the test %s] :\n\t    %s", test, this.formatErrorMessage(e));
                this.errStream.println(errorMsg);
            }
        }
    }

    private void executeFunction(Test test, TestSuite suite, String packageName, ClassLoader classLoader, Scheduler scheduler, AtomicBoolean shouldSkip, AtomicBoolean shouldSkipTest, List<String> failedOrSkippedTests) {
        try {
            if (this.isTestDependsOnFailedFunctions(test.getDependsOnTestFunctions(), failedOrSkippedTests)) {
                shouldSkipTest.set(true);
            }
            if (!shouldSkip.get() && !shouldSkipTest.get()) {
                Object valueSets = null;
                if (test.getDataProvider() != null) {
                    valueSets = this.invokeTestFunction(suite, test.getDataProvider(), classLoader, scheduler);
                }
                if (valueSets == null) {
                    this.invokeTestFunction(suite, test.getTestName(), classLoader, scheduler);
                    TesterinaResult functionResult = new TesterinaResult(test.getTestName(), true, shouldSkip.get(), null);
                    this.tReport.addFunctionResult(packageName, functionResult);
                } else {
                    Class<?>[] argTypes = BTestRunner.extractArgumentTypes(valueSets);
                    List<Object[]> argList = this.extractArguments(valueSets);
                    for (Object[] arg : argList) {
                        this.invokeTestFunction(suite, test.getTestName(), classLoader, scheduler, argTypes, arg);
                        TesterinaResult result = new TesterinaResult(test.getTestName(), true, shouldSkip.get(), null);
                        this.tReport.addFunctionResult(packageName, result);
                    }
                }
            } else {
                failedOrSkippedTests.add(test.getTestName());
                TesterinaResult functionResult = new TesterinaResult(test.getTestName(), false, true, null);
                this.tReport.addFunctionResult(packageName, functionResult);
            }
        }
        catch (Throwable e) {
            failedOrSkippedTests.add(test.getTestName());
            TesterinaResult functionResult = new TesterinaResult(test.getTestName(), false, shouldSkip.get(), this.formatErrorMessage(e));
            this.tReport.addFunctionResult(packageName, functionResult);
        }
    }

    private void executeAfterFunction(Test test, TestSuite suite, ClassLoader classLoader, Scheduler scheduler) {
        try {
            if (test.getAfterTestFunction() != null) {
                this.invokeTestFunction(suite, test.getAfterTestFunction(), classLoader, scheduler);
            }
        }
        catch (Throwable e) {
            String error = String.format("\t[fail] " + test + " [after test function for the test %s] :\n\t    %s", test, this.formatErrorMessage(e));
            this.errStream.println(error);
        }
    }

    private void executeAfterEachFunction(Test test, TestSuite suite, ClassLoader classLoader, Scheduler scheduler) {
        suite.getAfterEachFunctionNames().forEach(afterEachTest -> {
            try {
                this.invokeTestFunction(suite, (String)afterEachTest, classLoader, scheduler);
            }
            catch (Throwable e) {
                String errorMsg2 = String.format("\t[fail] " + afterEachTest + " [after each test function for the test %s] :\n\t    %s", test, this.formatErrorMessage(e));
                this.errStream.println(errorMsg2);
            }
        });
    }

    private void executeAfterSuiteFunctions(TestSuite suite, ClassLoader classLoader, Scheduler scheduler) {
        suite.getAfterSuiteFunctionNames().forEach(func -> {
            try {
                this.invokeTestFunction(suite, (String)func, classLoader, scheduler);
            }
            catch (Throwable e) {
                String errorMsg = String.format("\t[fail] " + func + " [after test suite function] :\n\t    %s", this.formatErrorMessage(e));
                this.errStream.println(errorMsg);
            }
        });
    }

    private void startSuite(TestSuite suite, Scheduler initScheduler, Class<?> initClazz, Class<?> testInitClazz, boolean hasTestablePackage) {
        TesterinaFunction init = new TesterinaFunction(initClazz, suite.getInitFunctionName(), initScheduler);
        TesterinaFunction start = new TesterinaFunction(initClazz, suite.getStartFunctionName(), initScheduler);
        init.setName("$moduleInit");
        init.invoke();
        if (hasTestablePackage) {
            TesterinaFunction testInit = new TesterinaFunction(testInitClazz, suite.getTestInitFunctionName(), initScheduler);
            testInit.invoke();
        }
        start.setName("$moduleStart");
        start.invoke();
        if (hasTestablePackage) {
            TesterinaFunction testStart = new TesterinaFunction(testInitClazz, suite.getTestStartFunctionName(), initScheduler);
            testStart.invoke();
        }
        initScheduler.immortal = true;
        Thread immortalThread = new Thread(() -> ((Scheduler)initScheduler).start(), "module-start");
        immortalThread.setDaemon(true);
        immortalThread.start();
    }

    private void stopSuite(TestSuite suite, Scheduler scheduler, Class<?> initClazz, Class<?> testInitClazz, boolean hasTestablePackage) {
        TesterinaFunction stop = new TesterinaFunction(initClazz, suite.getStopFunctionName(), scheduler);
        if (hasTestablePackage) {
            TesterinaFunction testStop = new TesterinaFunction(testInitClazz, suite.getTestStopFunctionName(), scheduler);
            testStop.scheduler = scheduler;
            testStop.invoke();
        }
        stop.setName("$moduleStop");
        stop.directInvoke(new Class[0]);
    }

    private Object invokeTestFunction(TestSuite suite, String functionName, ClassLoader classLoader, Scheduler scheduler) throws ClassNotFoundException {
        Class<?> functionClass = classLoader.loadClass(suite.getTestUtilityFunctions().get(functionName));
        TesterinaFunction testerinaFunction = new TesterinaFunction(functionClass, functionName, scheduler);
        return testerinaFunction.invoke();
    }

    public void invokeTestFunction(TestSuite suite, String functionName, ClassLoader classLoader, Scheduler scheduler, Class<?>[] types, Object[] args) throws ClassNotFoundException {
        Class<?> functionClass = classLoader.loadClass(suite.getTestUtilityFunctions().get(functionName));
        TesterinaFunction testerinaFunction = new TesterinaFunction(functionClass, functionName, scheduler);
        testerinaFunction.invoke(types, args);
    }

    private String formatErrorMessage(Throwable e) {
        String message;
        if (e.getCause() instanceof ErrorValue) {
            try {
                message = ((ErrorValue)e.getCause()).getPrintableStackTrace();
            }
            catch (ClassCastException castException) {
                throw new BallerinaException(e);
            }
        } else {
            if (e instanceof BallerinaException) {
                throw (BallerinaException)e;
            }
            throw new BallerinaException(e);
        }
        return message;
    }

    private boolean isTestDependsOnFailedFunctions(List<String> failedOrSkippedTests, List<String> dependentTests) {
        return ((Stream)failedOrSkippedTests.stream().parallel()).anyMatch(dependentTests::contains);
    }

    private List<Object[]> extractArguments(Object valueSets) {
        ArrayList<Object[]> argsList = new ArrayList<Object[]>();
        if (valueSets instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)valueSets;
            if (arrayValue.getElementType() instanceof BArrayType) {
                for (int i = 0; i < arrayValue.size(); ++i) {
                    BTestRunner.setTestFunctionParams(argsList, (ArrayValue)arrayValue.get((long)i));
                }
            } else {
                BTestRunner.setTestFunctionParams(argsList, arrayValue);
            }
        }
        return argsList;
    }

    private static Class<?>[] extractArgumentTypes(Object valueSets) {
        ArrayList typeList = new ArrayList();
        typeList.add(Strand.class);
        if (valueSets instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)valueSets;
            if (arrayValue.getElementType() instanceof BArrayType) {
                BTestRunner.setTestFunctionSignature(typeList, (ArrayValue)arrayValue.get(0L));
            } else {
                BTestRunner.setTestFunctionSignature(typeList, arrayValue);
            }
        }
        Class[] typeListArray = new Class[typeList.size()];
        typeList.toArray(typeListArray);
        return typeListArray;
    }

    private static void setTestFunctionSignature(List<Class<?>> typeList, ArrayValue arrayValue) {
        Class<?> type = BTestRunner.getArgTypeToClassMapping(arrayValue.getElementType());
        for (int i = 0; i < arrayValue.size(); ++i) {
            typeList.add(type);
            typeList.add(Boolean.TYPE);
        }
    }

    private static void setTestFunctionParams(List<Object[]> valueList, ArrayValue arrayValue) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new Object());
        for (int i = 0; i < arrayValue.size(); ++i) {
            params.add(arrayValue.get((long)i));
            params.add(Boolean.TRUE);
        }
        valueList.add(params.toArray());
    }

    private static Class<?> getArgTypeToClassMapping(BType elementType) {
        Class type = elementType instanceof BStringType ? String.class : (elementType instanceof BIntegerType ? Long.TYPE : (elementType instanceof BBooleanType ? Boolean.TYPE : (elementType instanceof BDecimalType ? DecimalValue.class : (elementType instanceof BByteType ? Integer.TYPE : (elementType instanceof BArrayType || elementType instanceof BTupleType ? ArrayValue.class : (elementType instanceof BFloatType ? Double.TYPE : (elementType instanceof BMapType || elementType instanceof BRecordType ? MapValue.class : (elementType instanceof BXMLType ? XMLValue.class : (elementType instanceof BObjectType ? ObjectValue.class : Object.class)))))))));
        return type;
    }

    public TesterinaReport getTesterinaReport() {
        return this.tReport;
    }
}

