/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.ballerinalang.jvm.util.RuntimeUtils;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.test.runtime.BTestRunner;
import org.ballerinalang.test.runtime.entity.TestSuite;

public class TesterinaUtils {
    private static final PrintStream outStream = System.out;
    private static final PrintStream errStream = System.err;

    public static void cleanUpDir(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException e) {
            errStream.println("Error occurred while deleting the dir : " + path.toString() + " with error : " + e.getMessage());
        }
    }

    public static void executeTests(Path sourceRootPath, TestSuite testSuite) throws RuntimeException {
        try {
            BTestRunner testRunner = new BTestRunner(outStream, errStream);
            testRunner.runTest(testSuite);
            TesterinaUtils.cleanUpDir(sourceRootPath.resolve(".testerina"));
            if (testRunner.getTesterinaReport().isFailure()) {
                throw new RuntimeException("there are test failures");
            }
        }
        catch (BallerinaException e) {
            errStream.println("error: " + e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            RuntimeUtils.silentlyLogBadSad((Throwable)e);
            throw new RuntimeException("test execution failed due to runtime exception");
        }
    }

    public static String formatError(String errorMsg) {
        StringBuilder newErrMsg = new StringBuilder();
        errorMsg = errorMsg.replaceAll("\n", "\n\t    ");
        List<String> msgParts = Arrays.asList(errorMsg.split("\n"));
        for (String msg : msgParts) {
            if (msgParts.indexOf(msg) != 0 && !msg.equals("\t    ")) {
                msg = "\t    \t" + msg.trim();
            }
            if (msg.equals("\t    ")) continue;
            newErrMsg.append(msg).append("\n");
        }
        return newErrMsg.toString();
    }

    public static String getQualifiedClassName(String orgName, String packageName, String className) {
        if (!".".equals(packageName)) {
            className = packageName.replace('.', '_') + "." + className;
        }
        if (!"$anon".equals(orgName)) {
            className = orgName.replace('.', '_') + "." + className;
        }
        return className;
    }
}

