/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.ballerinalang.jvm.launch.LaunchUtils;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.util.TesterinaUtils;

public class Main {
    public static void main(String[] args) throws Exception {
        Path jsonCachePath = Paths.get(args[0], "test_suit.json");
        Path jsonTmpSummaryPath = Paths.get(args[0], "module_status.json");
        String[] configArgs = Arrays.copyOfRange(args, 1, args.length);
        LaunchUtils.initConfigurations((String[])configArgs);
        BufferedReader br = Files.newBufferedReader(jsonCachePath, StandardCharsets.UTF_8);
        Gson gson = new Gson();
        TestSuite response = gson.fromJson((Reader)br, TestSuite.class);
        Main.startTestSuit(Paths.get(response.getSourceRootPath(), new String[0]), response, jsonTmpSummaryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startTestSuit(Path sourceRootPath, TestSuite testSuite, Path jsonTmpSummaryPath) throws ClassNotFoundException, IOException {
        int exitStatus = 0;
        try {
            TesterinaUtils.executeTests(sourceRootPath, testSuite);
        }
        catch (RuntimeException e) {
            exitStatus = 1;
        }
        finally {
            if (testSuite.isReportRequired()) {
                Main.writeStatusToJsonFile(ModuleStatus.getInstance(), jsonTmpSummaryPath);
            }
            Runtime.getRuntime().exit(exitStatus);
        }
    }

    private static void writeStatusToJsonFile(ModuleStatus moduleStatus, Path tmpJsonPath) throws IOException {
        File jsonFile = new File(tmpJsonPath.toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            String json = gson.toJson(moduleStatus);
            writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
    }
}

