/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.transaction;

import java.nio.charset.Charset;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.TransactionConstants;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.transaction", version="0.0.1", functionName="setTransactionContext", args={@Argument(name="transactionContext", type=TypeKind.RECORD), @Argument(name="prevAttempt", type=TypeKind.UNION)}, returnType={@ReturnType(type=TypeKind.NIL)}, isPublic=true)
public class SetTransactionContext {
    public static void setTransactionContext(Strand strand, MapValue txDataStruct, Object prevAttemptInfo) {
        String globalTransactionId = txDataStruct.get((Object)TransactionConstants.TRANSACTION_ID).toString();
        String transactionBlockId = txDataStruct.get((Object)TransactionConstants.TRANSACTION_BLOCK_ID).toString();
        String url = txDataStruct.get((Object)TransactionConstants.REGISTER_AT_URL).toString();
        String protocol = txDataStruct.get((Object)TransactionConstants.CORDINATION_TYPE).toString();
        long retryNmbr = SetTransactionContext.getRetryNumber(prevAttemptInfo);
        MapValue trxContext = BallerinaValues.createRecordValue((BPackage)TransactionConstants.TRANSACTION_PACKAGE_ID, (String)"Info");
        Object[] trxContextData = new Object[]{BValueCreator.createArrayValue((byte[])globalTransactionId.getBytes(Charset.defaultCharset())), retryNmbr, System.currentTimeMillis(), prevAttemptInfo};
        MapValue infoRecord = BallerinaValues.createRecord((MapValue)trxContext, (Object[])trxContextData);
        TransactionLocalContext trxCtx = TransactionLocalContext.createTransactionParticipantLocalCtx((String)globalTransactionId, (String)url, (String)protocol, (Object)infoRecord);
        trxCtx.beginTransactionBlock(transactionBlockId);
        strand.setCurrentTransactionContext(trxCtx);
    }

    private static long getRetryNumber(Object prevAttemptInfo) {
        if (prevAttemptInfo == null) {
            return 0L;
        }
        Map infoRecord = (Map)prevAttemptInfo;
        Long retryNumber = (Long)infoRecord.get(StringUtils.fromString((String)"retryNumber"));
        return retryNumber + 1L;
    }
}

