/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;

public class CassandraDataIterator
implements DataIterator {
    private Iterator<Row> iterator;
    private Row current;
    private List<ColumnDefinition> columnDefs;
    private BStructureType bStructType;

    public CassandraDataIterator(ResultSet rs, List<ColumnDefinition> columnDefs, BStructureType structType) {
        this.iterator = rs.iterator();
        this.columnDefs = columnDefs;
        this.bStructType = structType;
    }

    public boolean next() {
        boolean result = this.iterator.hasNext();
        if (result) {
            this.current = this.iterator.next();
        }
        return result;
    }

    public void close() {
    }

    public void reset() {
    }

    public String getString(int columnIndex) {
        this.checkCurrentRow();
        return this.current.getString(columnIndex - 1);
    }

    public long getInt(int columnIndex) {
        this.checkCurrentRow();
        return this.current.getInt(columnIndex - 1);
    }

    public double getFloat(int columnIndex) {
        this.checkCurrentRow();
        return this.current.getFloat(columnIndex - 1);
    }

    public boolean getBoolean(int columnIndex) {
        this.checkCurrentRow();
        return this.current.getBool(columnIndex - 1);
    }

    public String getBlob(int columnIndex) {
        this.checkCurrentRow();
        return CassandraDataIterator.getString(this.current.getBytes(columnIndex - 1));
    }

    public Object[] getStruct(int i) {
        return new Object[0];
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Functionality of obtaining an array is not implemented therefore it would be incorrect to return an empty array")
    public Object[] getArray(int columnIndex) {
        return null;
    }

    public BMap<String, BValue> generateNext() {
        BMap bStruct = new BMap((BType)this.bStructType);
        BField[] recordFields = this.bStructType.getFields();
        int index = 0;
        block6: for (ColumnDefinition columnDef : this.columnDefs) {
            String columnName = columnDef.getName();
            TypeKind type = columnDef.getType();
            String fieldName = recordFields[index].getFieldName();
            ++index;
            switch (type) {
                case STRING: {
                    String sValue = this.getString(index);
                    bStruct.put((Object)fieldName, (BValue)new BString(sValue));
                    continue block6;
                }
                case INT: {
                    long lValue = this.getInt(index);
                    bStruct.put((Object)fieldName, (BValue)new BInteger(lValue));
                    continue block6;
                }
                case FLOAT: {
                    double fValue = this.getFloat(index);
                    bStruct.put((Object)fieldName, (BValue)new BFloat(fValue));
                    continue block6;
                }
                case BOOLEAN: {
                    boolean boolValue = this.getBoolean(index);
                    bStruct.put((Object)fieldName, (BValue)new BBoolean(boolValue));
                    continue block6;
                }
            }
            throw new BallerinaException("unsupported sql type found for the column " + columnName);
        }
        return bStruct;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefs;
    }

    public BStructureType getStructType() {
        return this.bStructType;
    }

    private void checkCurrentRow() {
        if (this.current == null) {
            throw new BallerinaException("invalid position in the data iterator");
        }
    }

    private static String getString(ByteBuffer data) {
        if (data == null) {
            return null;
        }
        byte[] encode = CassandraDataIterator.getBase64Encode(new String(data.array(), Charset.defaultCharset()));
        return new String(encode, Charset.defaultCharset());
    }

    private static byte[] getBase64Encode(String st) {
        return Base64.getEncoder().encode(st.getBytes(Charset.defaultCharset()));
    }
}

