/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cassandra;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class CassandraDataSourceUtils {
    public static BMap<String, BValue> getCassandraConnectorError(Context context, Throwable throwable) {
        PackageInfo builtinPackage = context.getProgramFile().getPackageInfo("ballerina/builtin");
        StructureTypeInfo errorStructInfo = builtinPackage.getStructInfo("error");
        BMap cassandraConnectorError = new BMap((BType)errorStructInfo.getType());
        if (throwable.getMessage() == null) {
            cassandraConnectorError.put((Object)"message", (BValue)new BString("Exception Occurred while executing Cassandra database operation"));
        } else {
            cassandraConnectorError.put((Object)"message", (BValue)new BString(throwable.getMessage()));
        }
        return cassandraConnectorError;
    }

    public static String getCQLType(BType value) {
        int tag = value.getTag();
        switch (tag) {
            case 1: {
                return "INT";
            }
            case 4: {
                return "TEXT";
            }
            case 3: {
                return "FLOAT";
            }
            case 5: {
                return "BOOLEAN";
            }
        }
        throw new BallerinaException("unsupported data type for record field: " + value.getName());
    }
}

