/*
 * Copyright (c) 2017, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.ballerinalang.cassandra.actions;

import org.ballerinalang.bre.Context;
import org.ballerinalang.cassandra.CassandraDataSource;
import org.ballerinalang.cassandra.CassandraDataSourceUtils;
import org.ballerinalang.cassandra.Constants;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;

/**
 * {@code Update} action executes a given data or schema update query.
 *
 * @since 0.95.0
 */
@BallerinaFunction(
        orgName = "wso2",
        packageName = "cassandra:0.0.0",
        functionName = "update",
        receiver = @Receiver(type = TypeKind.OBJECT, structType = Constants.CLIENT),
        args = {@Argument(name = "queryString", type = TypeKind.STRING),
                @Argument(name = "parameters", type = TypeKind.ARRAY, elementType = TypeKind.RECORD,
                          structType = "Parameter")
        }
)
public class Update extends AbstractCassandraAction {
    @Override
    public void execute(Context context) {
        BMap<String, BValue> bConnector = (BMap<String, BValue>) context.getRefArgument(0);
        String query = context.getStringArgument(0);
        BValueArray parameters = (BValueArray) context.getNullableRefArgument(1);
        CassandraDataSource dataSource = (CassandraDataSource) bConnector.getNativeData(Constants.CLIENT);
        try {
            executeUpdate(context, dataSource, query, parameters);
        } catch (Throwable e) {
            context.setReturnValues(CassandraDataSourceUtils.getCassandraConnectorError(context, e));
        }
    }
}
