/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cassandra;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;

public class CassandraDataSource
implements BValue {
    private Cluster cluster;
    private Session session;

    public Cluster getCluster() {
        return this.cluster;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean init(String host, int port, String username, String password, Struct options) {
        Cluster.Builder builder = Cluster.builder();
        builder.addContactPoints(host.split(",")).build();
        if (port != -1) {
            builder.withPort(port);
        }
        this.populateAuthenticationOptions(builder, username, password);
        if (options != null) {
            builder = this.populateOptions(builder, options);
        }
        this.cluster = builder.build();
        this.session = this.cluster.connect();
        return true;
    }

    private Cluster.Builder populateOptions(Cluster.Builder builder, Struct options) {
        boolean metricsDisabled;
        boolean jmxReportingDisabled;
        String clusterName;
        Struct protocolOptionsConfig;
        Struct socketOptionsConfig;
        Struct poolingOptionsConfig;
        Struct queryOptionsConfig = options.getStructField(ConnectionParam.QUERY_OPTIONS.getKey());
        if (queryOptionsConfig != null) {
            this.populateQueryOptions(builder, queryOptionsConfig);
        }
        if ((poolingOptionsConfig = options.getStructField(ConnectionParam.POOLING_OPTIONS.getKey())) != null) {
            this.populatePoolingOptions(builder, poolingOptionsConfig);
        }
        if ((socketOptionsConfig = options.getStructField(ConnectionParam.SOCKET_OPTIONS.getKey())) != null) {
            this.populateSocketOptions(builder, socketOptionsConfig);
        }
        if ((protocolOptionsConfig = options.getStructField(ConnectionParam.PROTOCOL_OPTIONS.getKey())) != null) {
            this.populateProtocolOptions(builder, protocolOptionsConfig);
        }
        if (!(clusterName = options.getStringField(ConnectionParam.CLUSTER_NAME.getKey())).isEmpty()) {
            builder.withClusterName(clusterName);
        }
        if (jmxReportingDisabled = options.getBooleanField(ConnectionParam.WITHOUT_JMX_REPORTING.getKey())) {
            builder.withoutJMXReporting();
        }
        if (metricsDisabled = options.getBooleanField(ConnectionParam.WITHOUT_METRICS.getKey())) {
            builder.withoutMetrics();
        }
        this.populateLoadBalancingPolicy(builder, options);
        this.populateReconnectionPolicy(builder, options);
        this.populateRetryPolicy(builder, options);
        return builder;
    }

    private void populateRetryPolicy(Cluster.Builder builder, Struct options) {
        String retryPolicyString = options.getStringField(ConnectionParam.RETRY_POLICY.getKey());
        if (!retryPolicyString.isEmpty()) {
            RetryPolicy retryPolicy = this.retrieveRetryPolicy(retryPolicyString);
            switch (retryPolicy) {
                case DEFAULT_RETRY_POLICY: {
                    builder.withRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)DefaultRetryPolicy.INSTANCE);
                    break;
                }
                case FALLTHROUGH_RETRY_POLICY: {
                    builder.withRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)FallthroughRetryPolicy.INSTANCE);
                    break;
                }
                case DOWNGRADING_CONSISTENCY_RETRY_POLICY: {
                    builder.withRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
                    break;
                }
                case LOGGING_DEFAULT_RETRY_POLICY: {
                    builder.withRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)new LoggingRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)DefaultRetryPolicy.INSTANCE));
                    break;
                }
                case LOGGING_FALLTHROUGH_RETRY_POLICY: {
                    builder.withRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)new LoggingRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)FallthroughRetryPolicy.INSTANCE));
                    break;
                }
                case LOGGING_DOWNGRADING_CONSISTENCY_RETRY_POLICY: {
                    builder.withRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)new LoggingRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Support for the retry policy \"" + (Object)((Object)retryPolicy) + "\" is not implemented yet");
                }
            }
        }
    }

    private RetryPolicy retrieveRetryPolicy(String retryPolicy) {
        try {
            return RetryPolicy.fromPolicyName(retryPolicy);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaException("\"" + retryPolicy + "\" is not a valid retry policy");
        }
    }

    private void populateReconnectionPolicy(Cluster.Builder builder, Struct options) {
        String reconnectionPolicyString = options.getStringField(ConnectionParam.RECONNECTION_POLICY.getKey());
        if (!reconnectionPolicyString.isEmpty()) {
            ReconnectionPolicy reconnectionPolicy = this.retrieveReconnectionPolicy(reconnectionPolicyString);
            switch (reconnectionPolicy) {
                case CONSTANT_RECONNECTION_POLICY: {
                    long constantReconnectionPolicyDelay = options.getIntField(ConnectionParam.CONSTANT_RECONNECTION_POLICY_DELAY.getKey());
                    if (constantReconnectionPolicyDelay != -1L) {
                        builder.withReconnectionPolicy((com.datastax.driver.core.policies.ReconnectionPolicy)new ConstantReconnectionPolicy(constantReconnectionPolicyDelay));
                        break;
                    }
                    throw new BallerinaException("constantReconnectionPolicyDelay required for the initialization of ConstantReconnectionPolicy, has not been set");
                }
                case EXPONENTIAL_RECONNECTION_POLICY: {
                    long exponentialReconnectionPolicyBaseDelay = options.getIntField(ConnectionParam.EXPONENTIAL_RECONNECTION_POLICY_BASE_DELAY.getKey());
                    long exponentialReconnectionPolicyMaxDelay = options.getIntField(ConnectionParam.EXPONENTIAL_RECONNECTION_POLICY_MAX_DELAY.getKey());
                    if (exponentialReconnectionPolicyBaseDelay != -1L && exponentialReconnectionPolicyMaxDelay != -1L) {
                        builder.withReconnectionPolicy((com.datastax.driver.core.policies.ReconnectionPolicy)new ExponentialReconnectionPolicy(exponentialReconnectionPolicyBaseDelay, exponentialReconnectionPolicyMaxDelay));
                        break;
                    }
                    throw new BallerinaException("exponentialReconnectionPolicyBaseDelay or exponentialReconnectionPolicyMaxDelay required for the initialization of ConstantReconnectionPolicy, has not been set");
                }
                default: {
                    throw new UnsupportedOperationException("Support for the reconnection policy \"" + (Object)((Object)reconnectionPolicy) + "\" is not implemented yet");
                }
            }
        }
    }

    private ReconnectionPolicy retrieveReconnectionPolicy(String reconnectionPolicy) {
        try {
            return ReconnectionPolicy.fromPolicyName(reconnectionPolicy);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaException("\"" + reconnectionPolicy + "\"" + " is not a valid reconnection policy");
        }
    }

    private void populateLoadBalancingPolicy(Cluster.Builder builder, Struct options) {
        String dataCenter = options.getStringField(ConnectionParam.DATA_CENTER.getKey());
        String loadBalancingPolicyString = options.getStringField(ConnectionParam.LOAD_BALANCING_POLICY.getKey());
        boolean allowRemoteDCsForLocalConsistencyLevel = options.getBooleanField(ConnectionParam.ALLOW_REMOTE_DCS_FOR_LOCAL_CONSISTENCY_LEVEL.getKey());
        if (!loadBalancingPolicyString.isEmpty()) {
            LoadBalancingPolicy loadBalancingPolicy = this.retrieveLoadBalancingPolicy(loadBalancingPolicyString);
            switch (loadBalancingPolicy) {
                case DC_AWARE_ROUND_ROBIN_POLICY: {
                    if (dataCenter != null && !dataCenter.isEmpty()) {
                        if (allowRemoteDCsForLocalConsistencyLevel) {
                            builder.withLoadBalancingPolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(dataCenter).allowRemoteDCsForLocalConsistencyLevel().build());
                            break;
                        }
                        builder.withLoadBalancingPolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().withLocalDc(dataCenter).build());
                        break;
                    }
                    if (allowRemoteDCsForLocalConsistencyLevel) {
                        builder.withLoadBalancingPolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().allowRemoteDCsForLocalConsistencyLevel().build());
                        break;
                    }
                    builder.withLoadBalancingPolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build());
                    break;
                }
                case LATENCY_AWARE_ROUND_ROBIN_POLICY: {
                    builder.withLoadBalancingPolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)LatencyAwarePolicy.builder((com.datastax.driver.core.policies.LoadBalancingPolicy)new RoundRobinPolicy()).build());
                    break;
                }
                case ROUND_ROBIN_POLICY: {
                    builder.withLoadBalancingPolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)new RoundRobinPolicy());
                    break;
                }
                case TOKEN_AWARE_ROUND_ROBIN_POLICY: {
                    builder.withLoadBalancingPolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)new TokenAwarePolicy((com.datastax.driver.core.policies.LoadBalancingPolicy)new RoundRobinPolicy()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Support for the load balancing policy \"" + (Object)((Object)loadBalancingPolicy) + "\" is not implemented yet");
                }
            }
        }
    }

    private LoadBalancingPolicy retrieveLoadBalancingPolicy(String loadBalancingPolicy) {
        try {
            return LoadBalancingPolicy.fromPolicyName(loadBalancingPolicy);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaException("\"" + loadBalancingPolicy + "\"" + " is not a valid load balancing policy");
        }
    }

    private void populateAuthenticationOptions(Cluster.Builder builder, String username, String password) {
        builder.withAuthProvider((AuthProvider)new PlainTextAuthProvider(username, password));
    }

    private void populateQueryOptions(Cluster.Builder builder, Struct queryOptionsConfig) {
        QueryOptions queryOptions = new QueryOptions();
        String consistencyLevel = queryOptionsConfig.getStringField(QueryOptionsParam.CONSISTENCY_LEVEL.getKey());
        String serialConsistencyLevel = queryOptionsConfig.getStringField(QueryOptionsParam.SERIAL_CONSISTENCY_LEVEL.getKey());
        boolean defaultIdempotence = queryOptionsConfig.getBooleanField(QueryOptionsParam.DEFAULT_IDEMPOTENCE.getKey());
        boolean metadataEnabled = queryOptionsConfig.getBooleanField(QueryOptionsParam.METADATA_ENABLED.getKey());
        boolean reprepareOnUp = queryOptionsConfig.getBooleanField(QueryOptionsParam.REPREPARE_ON_UP.getKey());
        queryOptions.setReprepareOnUp(reprepareOnUp);
        boolean prepareOnAllHosts = queryOptionsConfig.getBooleanField(QueryOptionsParam.PREPARE_ON_ALL_HOSTS.getKey());
        queryOptions.setPrepareOnAllHosts(prepareOnAllHosts);
        int fetchSize = (int)queryOptionsConfig.getIntField(QueryOptionsParam.FETCH_SIZE.getKey());
        int maxPendingRefreshNodeListRequests = (int)queryOptionsConfig.getIntField(QueryOptionsParam.MAX_PENDING_REFRESH_NODELIST_REQUESTS.getKey());
        int maxPendingRefreshNodeRequests = (int)queryOptionsConfig.getIntField(QueryOptionsParam.MAX_PENDING_REFRESH_NODE_REQUESTS.getKey());
        int maxPendingRefreshSchemaRequests = (int)queryOptionsConfig.getIntField(QueryOptionsParam.MAX_PENDING_REFRESH_SCHEMA_REQUESTS.getKey());
        int refreshNodeListIntervalMillis = (int)queryOptionsConfig.getIntField(QueryOptionsParam.REFRESH_NODELIST_INTERVAL_MILLIS.getKey());
        int refreshNodeIntervalMillis = (int)queryOptionsConfig.getIntField(QueryOptionsParam.REFRESH_NODE_INTERNAL_MILLIS.getKey());
        int refreshSchemaIntervalMillis = (int)queryOptionsConfig.getIntField(QueryOptionsParam.REFRESH_SCHEMA_INTERVAL_MILLIS.getKey());
        if (!consistencyLevel.isEmpty()) {
            queryOptions.setConsistencyLevel(this.retrieveConsistencyLevel(consistencyLevel));
        }
        if (!serialConsistencyLevel.isEmpty()) {
            queryOptions.setSerialConsistencyLevel(this.retrieveSerialConsistencyLevel(serialConsistencyLevel));
        }
        queryOptions.setDefaultIdempotence(defaultIdempotence);
        queryOptions.setMetadataEnabled(metadataEnabled);
        if (fetchSize != -1) {
            queryOptions.setFetchSize(fetchSize);
        }
        if (maxPendingRefreshNodeListRequests != -1) {
            queryOptions.setMaxPendingRefreshNodeListRequests(maxPendingRefreshNodeListRequests);
        }
        if (maxPendingRefreshNodeRequests != -1) {
            queryOptions.setMaxPendingRefreshNodeRequests(maxPendingRefreshNodeRequests);
        }
        if (maxPendingRefreshSchemaRequests != -1) {
            queryOptions.setMaxPendingRefreshSchemaRequests(maxPendingRefreshSchemaRequests);
        }
        if (refreshNodeListIntervalMillis != -1) {
            queryOptions.setRefreshNodeIntervalMillis(refreshNodeListIntervalMillis);
        }
        if (refreshNodeIntervalMillis != -1) {
            queryOptions.setRefreshNodeIntervalMillis(refreshNodeIntervalMillis);
        }
        if (refreshSchemaIntervalMillis != -1) {
            queryOptions.setRefreshSchemaIntervalMillis(refreshSchemaIntervalMillis);
        }
        builder.withQueryOptions(queryOptions);
    }

    private void populatePoolingOptions(Cluster.Builder builder, Struct poolingOptionsConfig) {
        PoolingOptions poolingOptions = new PoolingOptions();
        int coreConnectionsPerHostLocal = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.CORE_CONNECTIONS_PER_HOST_LOCAL.getKey());
        int maxConnectionsPerHostLocal = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.MAX_CONNECTIONS_PER_HOST_LOCAL.getKey());
        int newConnectionThresholdLocal = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.NEW_CONNECTION_THRESHOLD_LOCAL.getKey());
        int coreConnectionsPerHostRemote = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.CORE_CONNECTIONS_PER_HOST_REMOTE.getKey());
        int maxConnectionsPerHostRemote = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.MAX_CONNECTIONS_PER_HOST_REMOTE.getKey());
        int newConnectionThresholdRemote = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.NEW_CONNECTION_THRESHOLD_REMOTE.getKey());
        int maxRequestsPerConnectionLocal = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.MAX_REQUESTS_PER_CONNECTION_LOCAL.getKey());
        int maxRequestsPerConnectionRemote = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.MAX_REQUESTS_PER_CONNECTION_REMOTE.getKey());
        int idleTimeoutSeconds = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.IDLE_TIMEOUT_SECONDS.getKey());
        int poolTimeoutMillis = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.POOL_TIMEOUT_MILLIS.getKey());
        int maxQueueSize = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.MAX_QUEUE_SIZE.getKey());
        int heartbeatIntervalSeconds = (int)poolingOptionsConfig.getIntField(PoolingOptionsParam.HEART_BEAT_INTERVAL_SECONDS.getKey());
        if (coreConnectionsPerHostLocal != -1) {
            poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, coreConnectionsPerHostLocal);
        }
        if (coreConnectionsPerHostRemote != -1) {
            poolingOptions.setCoreConnectionsPerHost(HostDistance.REMOTE, coreConnectionsPerHostRemote);
        }
        if (maxConnectionsPerHostLocal != -1) {
            poolingOptions.setMaxConnectionsPerHost(HostDistance.LOCAL, maxConnectionsPerHostLocal);
        }
        if (maxConnectionsPerHostRemote != -1) {
            poolingOptions.setMaxConnectionsPerHost(HostDistance.REMOTE, maxConnectionsPerHostRemote);
        }
        if (newConnectionThresholdLocal != -1) {
            poolingOptions.setNewConnectionThreshold(HostDistance.LOCAL, newConnectionThresholdLocal);
        }
        if (newConnectionThresholdRemote != -1) {
            poolingOptions.setNewConnectionThreshold(HostDistance.REMOTE, newConnectionThresholdRemote);
        }
        if (maxRequestsPerConnectionLocal != -1) {
            poolingOptions.setMaxRequestsPerConnection(HostDistance.LOCAL, maxRequestsPerConnectionLocal);
        }
        if (maxRequestsPerConnectionRemote != -1) {
            poolingOptions.setMaxRequestsPerConnection(HostDistance.REMOTE, maxRequestsPerConnectionRemote);
        }
        if (idleTimeoutSeconds != -1) {
            poolingOptions.setIdleTimeoutSeconds(idleTimeoutSeconds);
        }
        if (poolTimeoutMillis != -1) {
            poolingOptions.setPoolTimeoutMillis(poolTimeoutMillis);
        }
        if (maxQueueSize != -1) {
            poolingOptions.setMaxQueueSize(maxQueueSize);
        }
        if (heartbeatIntervalSeconds != -1) {
            poolingOptions.setHeartbeatIntervalSeconds(heartbeatIntervalSeconds);
        }
        builder.withPoolingOptions(poolingOptions);
    }

    private void populateSocketOptions(Cluster.Builder builder, Struct socketOptionsConfig) {
        SocketOptions socketOptions = new SocketOptions();
        int connectTimeoutMillis = (int)socketOptionsConfig.getIntField(SocketOptionsParam.CONNECT_TIMEOUT_MILLIS.getKey());
        int readTimeoutMillis = (int)socketOptionsConfig.getIntField(SocketOptionsParam.READ_TIMEOUT_MILLIS.getKey());
        int soLinger = (int)socketOptionsConfig.getIntField(SocketOptionsParam.SO_LINGER.getKey());
        int receiveBufferSize = (int)socketOptionsConfig.getIntField(SocketOptionsParam.RECEIVE_BUFFER_SIZE.getKey());
        int sendBufferSize = (int)socketOptionsConfig.getIntField(SocketOptionsParam.SEND_BUFFER_SIZE.getKey());
        if (connectTimeoutMillis != -1) {
            socketOptions.setConnectTimeoutMillis(connectTimeoutMillis);
        }
        if (readTimeoutMillis != -1) {
            socketOptions.setReadTimeoutMillis(readTimeoutMillis);
        }
        if (soLinger != -1) {
            socketOptions.setSoLinger(soLinger);
        }
        if (receiveBufferSize != -1) {
            socketOptions.setReceiveBufferSize(receiveBufferSize);
        }
        if (sendBufferSize != -1) {
            socketOptions.setSendBufferSize(sendBufferSize);
        }
        builder.withSocketOptions(socketOptions);
    }

    private void populateProtocolOptions(Cluster.Builder builder, Struct protocolOptionsConfig) {
        boolean sslEnabled = protocolOptionsConfig.getBooleanField(ProtocolOptionsParam.SSL_ENABLED.getKey());
        boolean noCompact = protocolOptionsConfig.getBooleanField(ProtocolOptionsParam.NO_COMPACT.getKey());
        int maxSchemaAgreementWaitSeconds = (int)protocolOptionsConfig.getIntField(ProtocolOptionsParam.MAX_SCHEMA_AGREEMENT_WAIT_SECONDS.getKey());
        String compression = protocolOptionsConfig.getStringField(ProtocolOptionsParam.COMPRESSION.getKey());
        String initialProtocolVersion = protocolOptionsConfig.getStringField(ProtocolOptionsParam.INITIAL_PROTOCOL_VERSION.getKey());
        if (sslEnabled) {
            builder = builder.withSSL();
        }
        if (noCompact) {
            builder.withNoCompact();
        }
        if (maxSchemaAgreementWaitSeconds != -1) {
            builder.withMaxSchemaAgreementWaitSeconds(maxSchemaAgreementWaitSeconds);
        }
        if (!compression.isEmpty()) {
            builder.withCompression(this.retrieveCompression(compression));
        }
        if (!initialProtocolVersion.isEmpty()) {
            builder.withProtocolVersion(this.retrieveProtocolVersion(initialProtocolVersion));
        }
    }

    public String stringValue() {
        return null;
    }

    public BType getType() {
        return null;
    }

    public void stamp(BType bType, List<BVM.TypeValuePair> list) {
    }

    public BValue copy(Map<BValue, BValue> map) {
        return null;
    }

    private ProtocolVersion retrieveProtocolVersion(String protocolVersion) {
        try {
            return ProtocolVersion.valueOf((String)protocolVersion);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaException("\"" + protocolVersion + "\" is not a valid protocol version");
        }
    }

    private ProtocolOptions.Compression retrieveCompression(String compression) {
        try {
            return ProtocolOptions.Compression.valueOf((String)compression);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaException("\"" + compression + "\" is not a valid compression type");
        }
    }

    private ConsistencyLevel retrieveSerialConsistencyLevel(String consistencyLevel) {
        try {
            ConsistencyLevel serialConsistencyLevel = ConsistencyLevel.valueOf((String)consistencyLevel);
            if (serialConsistencyLevel.isSerial()) {
                return serialConsistencyLevel;
            }
            throw new BallerinaException("\"" + consistencyLevel + "\" is not a valid serial consistency level");
        }
        catch (DriverInternalError e) {
            throw new BallerinaException("\"" + consistencyLevel + "\" is not a valid serial consistency level");
        }
    }

    private ConsistencyLevel retrieveConsistencyLevel(String consistencyLevel) {
        try {
            return ConsistencyLevel.valueOf((String)consistencyLevel);
        }
        catch (DriverInternalError e) {
            throw new BallerinaException("\"" + consistencyLevel + "\" is not a valid consistency level");
        }
    }

    private static final class RetryPolicy
    extends Enum<RetryPolicy> {
        public static final /* enum */ RetryPolicy DEFAULT_RETRY_POLICY;
        public static final /* enum */ RetryPolicy DOWNGRADING_CONSISTENCY_RETRY_POLICY;
        public static final /* enum */ RetryPolicy FALLTHROUGH_RETRY_POLICY;
        public static final /* enum */ RetryPolicy LOGGING_DEFAULT_RETRY_POLICY;
        public static final /* enum */ RetryPolicy LOGGING_DOWNGRADING_CONSISTENCY_RETRY_POLICY;
        public static final /* enum */ RetryPolicy LOGGING_FALLTHROUGH_RETRY_POLICY;
        private String retryPolicy;
        private static final Map<String, RetryPolicy> policyMap;
        private static final /* synthetic */ RetryPolicy[] $VALUES;

        public static RetryPolicy[] values() {
            return (RetryPolicy[])$VALUES.clone();
        }

        public static RetryPolicy valueOf(String name) {
            return Enum.valueOf(RetryPolicy.class, name);
        }

        private RetryPolicy(String retryPolicy) {
            this.retryPolicy = retryPolicy;
        }

        private String getPolicyName() {
            return this.retryPolicy;
        }

        public static RetryPolicy fromPolicyName(String policyName) {
            RetryPolicy mechanism = policyMap.get(policyName);
            if (mechanism == null) {
                throw new IllegalArgumentException("Unsupported Retry policy: " + policyName);
            }
            return mechanism;
        }

        static {
            RetryPolicy[] policies;
            DEFAULT_RETRY_POLICY = new RetryPolicy("DefaultRetryPolicy");
            DOWNGRADING_CONSISTENCY_RETRY_POLICY = new RetryPolicy("DowngradingConsistencyRetryPolicy");
            FALLTHROUGH_RETRY_POLICY = new RetryPolicy("FallthroughRetryPolicy");
            LOGGING_DEFAULT_RETRY_POLICY = new RetryPolicy("LoggingDefaultRetryPolicy");
            LOGGING_DOWNGRADING_CONSISTENCY_RETRY_POLICY = new RetryPolicy("LoggingDowngradingConsistencyRetryPolicy");
            LOGGING_FALLTHROUGH_RETRY_POLICY = new RetryPolicy("LoggingFallthroughRetryPolicy");
            $VALUES = new RetryPolicy[]{DEFAULT_RETRY_POLICY, DOWNGRADING_CONSISTENCY_RETRY_POLICY, FALLTHROUGH_RETRY_POLICY, LOGGING_DEFAULT_RETRY_POLICY, LOGGING_DOWNGRADING_CONSISTENCY_RETRY_POLICY, LOGGING_FALLTHROUGH_RETRY_POLICY};
            policyMap = new HashMap<String, RetryPolicy>();
            for (RetryPolicy policy : policies = RetryPolicy.values()) {
                policyMap.put(policy.getPolicyName(), policy);
            }
        }
    }

    private static final class ReconnectionPolicy
    extends Enum<ReconnectionPolicy> {
        public static final /* enum */ ReconnectionPolicy CONSTANT_RECONNECTION_POLICY;
        public static final /* enum */ ReconnectionPolicy EXPONENTIAL_RECONNECTION_POLICY;
        private String reconnectionPolicy;
        private static final Map<String, ReconnectionPolicy> policyMap;
        private static final /* synthetic */ ReconnectionPolicy[] $VALUES;

        public static ReconnectionPolicy[] values() {
            return (ReconnectionPolicy[])$VALUES.clone();
        }

        public static ReconnectionPolicy valueOf(String name) {
            return Enum.valueOf(ReconnectionPolicy.class, name);
        }

        private ReconnectionPolicy(String reconnectionPolicy) {
            this.reconnectionPolicy = reconnectionPolicy;
        }

        public static ReconnectionPolicy fromPolicyName(String policyName) {
            ReconnectionPolicy policy = policyMap.get(policyName);
            if (policy == null) {
                throw new IllegalArgumentException("Unsupported Reconnection policy: " + policyName);
            }
            return policy;
        }

        private String getPolicyName() {
            return this.reconnectionPolicy;
        }

        static {
            ReconnectionPolicy[] policies;
            CONSTANT_RECONNECTION_POLICY = new ReconnectionPolicy("ConstantReconnectionPolicy");
            EXPONENTIAL_RECONNECTION_POLICY = new ReconnectionPolicy("ExponentialReconnectionPolicy");
            $VALUES = new ReconnectionPolicy[]{CONSTANT_RECONNECTION_POLICY, EXPONENTIAL_RECONNECTION_POLICY};
            policyMap = new HashMap<String, ReconnectionPolicy>();
            for (ReconnectionPolicy policy : policies = ReconnectionPolicy.values()) {
                policyMap.put(policy.getPolicyName(), policy);
            }
        }
    }

    private static final class LoadBalancingPolicy
    extends Enum<LoadBalancingPolicy> {
        public static final /* enum */ LoadBalancingPolicy DC_AWARE_ROUND_ROBIN_POLICY;
        public static final /* enum */ LoadBalancingPolicy LATENCY_AWARE_ROUND_ROBIN_POLICY;
        public static final /* enum */ LoadBalancingPolicy ROUND_ROBIN_POLICY;
        public static final /* enum */ LoadBalancingPolicy TOKEN_AWARE_ROUND_ROBIN_POLICY;
        private String loadBalancingPolicy;
        private static final Map<String, LoadBalancingPolicy> policyMap;
        private static final /* synthetic */ LoadBalancingPolicy[] $VALUES;

        public static LoadBalancingPolicy[] values() {
            return (LoadBalancingPolicy[])$VALUES.clone();
        }

        public static LoadBalancingPolicy valueOf(String name) {
            return Enum.valueOf(LoadBalancingPolicy.class, name);
        }

        private LoadBalancingPolicy(String loadBalancingPolicy) {
            this.loadBalancingPolicy = loadBalancingPolicy;
        }

        public static LoadBalancingPolicy fromPolicyName(String policyName) {
            LoadBalancingPolicy policy = policyMap.get(policyName);
            if (policy == null) {
                throw new IllegalArgumentException("Unsupported Load Balancing policy: " + policyName);
            }
            return policy;
        }

        private String getPolicyName() {
            return this.loadBalancingPolicy;
        }

        static {
            LoadBalancingPolicy[] policies;
            DC_AWARE_ROUND_ROBIN_POLICY = new LoadBalancingPolicy("DCAwareRoundRobinPolicy");
            LATENCY_AWARE_ROUND_ROBIN_POLICY = new LoadBalancingPolicy("LatencyAwarePolicy");
            ROUND_ROBIN_POLICY = new LoadBalancingPolicy("RoundRobinPolicy");
            TOKEN_AWARE_ROUND_ROBIN_POLICY = new LoadBalancingPolicy("TokenAwarePolicy");
            $VALUES = new LoadBalancingPolicy[]{DC_AWARE_ROUND_ROBIN_POLICY, LATENCY_AWARE_ROUND_ROBIN_POLICY, ROUND_ROBIN_POLICY, TOKEN_AWARE_ROUND_ROBIN_POLICY};
            policyMap = new HashMap<String, LoadBalancingPolicy>();
            for (LoadBalancingPolicy policy : policies = LoadBalancingPolicy.values()) {
                policyMap.put(policy.getPolicyName(), policy);
            }
        }
    }

    private static enum ConnectionParam {
        CLUSTER_NAME("clusterName"),
        LOAD_BALANCING_POLICY("loadBalancingPolicy"),
        RECONNECTION_POLICY("reconnectionPolicy"),
        RETRY_POLICY("retryPolicy"),
        DATA_CENTER("dataCenter"),
        WITHOUT_METRICS("withoutMetrics"),
        WITHOUT_JMX_REPORTING("withoutJMXReporting"),
        ALLOW_REMOTE_DCS_FOR_LOCAL_CONSISTENCY_LEVEL("allowRemoteDCsForLocalConsistencyLevel"),
        CONSTANT_RECONNECTION_POLICY_DELAY("constantReconnectionPolicyDelay"),
        EXPONENTIAL_RECONNECTION_POLICY_BASE_DELAY("exponentialReconnectionPolicyBaseDelay"),
        EXPONENTIAL_RECONNECTION_POLICY_MAX_DELAY("exponentialReconnectionPolicyMaxDelay"),
        QUERY_OPTIONS("queryOptionsConfig"),
        POOLING_OPTIONS("poolingOptionsConfig"),
        SOCKET_OPTIONS("socketOptionsConfig"),
        PROTOCOL_OPTIONS("protocolOptionsConfig");

        private String key;

        private ConnectionParam(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }

    private static enum ProtocolOptionsParam {
        SSL_ENABLED("sslEnabled"),
        NO_COMPACT("noCompact"),
        MAX_SCHEMA_AGREEMENT_WAIT_SECONDS("maxSchemaAgreementWaitSeconds"),
        INITIAL_PROTOCOL_VERSION("initialProtocolVersion"),
        COMPRESSION("compression");

        private String key;

        private ProtocolOptionsParam(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }

    private static enum QueryOptionsParam {
        CONSISTENCY_LEVEL("consistencyLevel"),
        SERIAL_CONSISTENCY_LEVEL("serialConsistencyLevel"),
        DEFAULT_IDEMPOTENCE("defaultIdempotence"),
        METADATA_ENABLED("metadataEnabled"),
        REPREPARE_ON_UP("reprepareOnUp"),
        PREPARE_ON_ALL_HOSTS("prepareOnAllHosts"),
        FETCH_SIZE("fetchSize"),
        MAX_PENDING_REFRESH_NODELIST_REQUESTS("maxPendingRefreshNodeListRequests"),
        MAX_PENDING_REFRESH_NODE_REQUESTS("maxPendingRefreshNodeRequests"),
        MAX_PENDING_REFRESH_SCHEMA_REQUESTS("maxPendingRefreshSchemaRequests"),
        REFRESH_NODELIST_INTERVAL_MILLIS("refreshNodeListIntervalMillis"),
        REFRESH_NODE_INTERNAL_MILLIS("refreshNodeIntervalMillis"),
        REFRESH_SCHEMA_INTERVAL_MILLIS("refreshSchemaIntervalMillis");

        private String key;

        private QueryOptionsParam(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }

    private static enum PoolingOptionsParam {
        MAX_REQUESTS_PER_CONNECTION_LOCAL("maxRequestsPerConnectionLocal"),
        MAX_REQUESTS_PER_CONNECTION_REMOTE("maxRequestsPerConnectionRemote"),
        IDLE_TIMEOUT_SECONDS("idleTimeoutSeconds"),
        POOL_TIMEOUT_MILLIS("poolTimeoutMillis"),
        MAX_QUEUE_SIZE("maxQueueSize"),
        HEART_BEAT_INTERVAL_SECONDS("heartbeatIntervalSeconds"),
        CORE_CONNECTIONS_PER_HOST_LOCAL("coreConnectionsPerHostLocal"),
        MAX_CONNECTIONS_PER_HOST_LOCAL("maxConnectionsPerHostLocal"),
        NEW_CONNECTION_THRESHOLD_LOCAL("newConnectionThresholdLocal"),
        CORE_CONNECTIONS_PER_HOST_REMOTE("coreConnectionsPerHostRemote"),
        MAX_CONNECTIONS_PER_HOST_REMOTE("maxConnectionsPerHostRemote"),
        NEW_CONNECTION_THRESHOLD_REMOTE("newConnectionThresholdRemote");

        private String key;

        private PoolingOptionsParam(String index) {
            this.key = index;
        }

        private String getKey() {
            return this.key;
        }
    }

    private static enum SocketOptionsParam {
        CONNECT_TIMEOUT_MILLIS("connectTimeoutMillis"),
        READ_TIMEOUT_MILLIS("readTimeoutMillis"),
        SO_LINGER("soLinger"),
        RECEIVE_BUFFER_SIZE("receiveBufferSize"),
        SEND_BUFFER_SIZE("sendBufferSize"),
        KEEP_ALIVE("keepAlive"),
        REUSE_ADDRESS("reuseAddress"),
        TCP_NO_DELAY("tcpNoDelay");

        private String key;

        private SocketOptionsParam(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }
}

