/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cassandra.actions;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.cassandra.CassandraDataIterator;
import org.ballerinalang.cassandra.CassandraDataSource;
import org.ballerinalang.cassandra.CassandraDataSourceUtils;
import org.ballerinalang.database.table.BCursorTable;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public abstract class AbstractCassandraAction
extends BlockingNativeCallableUnit {
    public BTable executeSelect(Context context, CassandraDataSource dataSource, String query, BValueArray parameters, BStructureType type) {
        BValueArray uniformParams = this.constructUniformArrayOfParameters(parameters, context);
        String processedQuery = this.createProcessedQueryString(query, uniformParams);
        PreparedStatement preparedStatement = dataSource.getSession().prepare(processedQuery);
        BoundStatement stmt = this.createBoundStatement(preparedStatement, uniformParams);
        ResultSet rs = dataSource.getSession().execute((Statement)stmt);
        return new BCursorTable((DataIterator)new CassandraDataIterator(rs, this.getColumnDefinitions(rs), type), type);
    }

    public void executeUpdate(Context context, CassandraDataSource dataSource, String query, BValueArray parameters) {
        BValueArray uniformParams = this.constructUniformArrayOfParameters(parameters, context);
        String processedQuery = this.createProcessedQueryString(query, uniformParams);
        PreparedStatement preparedStatement = dataSource.getSession().prepare(processedQuery);
        BoundStatement stmt = this.createBoundStatement(preparedStatement, uniformParams);
        dataSource.getSession().execute((Statement)stmt);
    }

    protected void close(CassandraDataSource dbDataSource) {
        dbDataSource.getSession().close();
        dbDataSource.getCluster().close();
    }

    protected BStructureType getStructType(Context context) {
        BStructureType structType = null;
        BTypeDescValue type = (BTypeDescValue)context.getNullableRefArgument(1);
        if (type != null) {
            structType = (BStructureType)type.value();
        }
        return structType;
    }

    private BValueArray constructUniformArrayOfParameters(BValueArray inputParams, Context context) {
        BValueArray uniformParams = new BValueArray();
        int count = (int)inputParams.size();
        for (int i = 0; i < count; ++i) {
            BMap<String, BValue> param;
            BRefType typeValue = inputParams.getRefValue((long)i);
            if (typeValue.getType().getTag() == 12) {
                param = (BMap<String, BValue>)typeValue;
            } else {
                param = AbstractCassandraAction.createCQLParameter(context);
                param.put((Object)"cqlType", (BValue)new BString(CassandraDataSourceUtils.getCQLType(typeValue.getType())));
                param.put((Object)"value", (BValue)typeValue);
            }
            uniformParams.add((long)i, param);
        }
        return uniformParams;
    }

    private static BMap<String, BValue> createCQLParameter(Context context) {
        PackageInfo sqlPackageInfo = context.getProgramFile().getPackageInfo("wso2/cassandra:0.0.0");
        StructureTypeInfo paramStructInfo = sqlPackageInfo.getStructInfo("Parameter");
        return new BMap((BType)paramStructInfo.getType());
    }

    private List<ColumnDefinition> getColumnDefinitions(ResultSet rs) {
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnDefinitions.Definition def : rs.getColumnDefinitions().asList()) {
            String colName = def.getName();
            if (columnNames.contains(colName)) {
                String tableName = def.getTable().toUpperCase(Locale.ENGLISH);
                colName = tableName + "." + colName;
            }
            columnDefs.add(new ColumnDefinition(colName, this.convert(def.getType())));
            columnNames.add(colName);
        }
        return columnDefs;
    }

    private TypeKind convert(DataType type) {
        if (DataType.ascii().equals(type)) {
            return TypeKind.STRING;
        }
        if (DataType.text().equals(type)) {
            return TypeKind.STRING;
        }
        if (DataType.uuid().equals(type)) {
            return TypeKind.STRING;
        }
        if (DataType.varchar().equals(type)) {
            return TypeKind.STRING;
        }
        if (DataType.bigint().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.cint().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.counter().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.date().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.decimal().equals(type)) {
            return TypeKind.FLOAT;
        }
        if (DataType.smallint().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.time().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.timestamp().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.tinyint().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.varint().equals(type)) {
            return TypeKind.INT;
        }
        if (DataType.cboolean().equals(type)) {
            return TypeKind.BOOLEAN;
        }
        if (DataType.cdouble().equals(type)) {
            return TypeKind.FLOAT;
        }
        if (DataType.cfloat().equals(type)) {
            return TypeKind.FLOAT;
        }
        if (DataType.blob().equals(type)) {
            return TypeKind.ARRAY;
        }
        return TypeKind.STRING;
    }

    private String createProcessedQueryString(String query, BValueArray parameters) {
        String currentQuery = query;
        if (parameters != null) {
            int start = 0;
            int paramCount = (int)parameters.size();
            for (int i = 0; i < paramCount; ++i) {
                BMap paramStruct = (BMap)parameters.getBValue((long)i);
                if (paramStruct == null) continue;
                String cqlType = this.getCQLType((BMap<String, BValue>)paramStruct);
                BValue value = paramStruct.get((Object)"value");
                int count = value != null && value.getType().getTag() == 20 && !"LIST".equalsIgnoreCase(cqlType) ? (int)((BNewArray)value).size() : 1;
                Object[] vals = this.expandQuery(start, count, currentQuery);
                start = (Integer)vals[0];
                currentQuery = (String)vals[1];
            }
        }
        return currentQuery;
    }

    private Object[] expandQuery(int start, int count, String query) {
        StringBuilder result = new StringBuilder();
        int n = query.length();
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        int end = n;
        for (int i = start; i < n; ++i) {
            if (query.charAt(i) == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (query.charAt(i) == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (query.charAt(i) != '?' || doubleQuoteExists || singleQuoteExists) continue;
            result.append(query.substring(0, i));
            result.append(this.generateQuestionMarks(count));
            end = result.length() + 1;
            if (i + 1 >= n) break;
            result.append(query.substring(i + 1));
            break;
        }
        return new Object[]{end, result.toString()};
    }

    private String generateQuestionMarks(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append("?");
            if (i + 1 >= n) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private BoundStatement createBoundStatement(PreparedStatement stmt, BValueArray params) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        BoundStatement boundStmt = stmt.bind();
        if (params == null) {
            return boundStmt;
        }
        int paramCount = (int)params.size();
        for (int index = 0; index < paramCount; ++index) {
            BMap paramStruct = (BMap)params.getBValue((long)index);
            if (paramStruct != null) {
                String cqlType = this.getCQLType((BMap<String, BValue>)paramStruct);
                BValue value = paramStruct.get((Object)"value");
                if (value != null && value.getType().getTag() == 20 && !"LIST".equalsIgnoreCase(cqlType)) {
                    int arrayLength = (int)((BNewArray)value).size();
                    int typeTag = ((BArrayType)value.getType()).getElementType().getTag();
                    for (int i = 0; i < arrayLength; ++i) {
                        BInteger paramValue;
                        switch (typeTag) {
                            case 1: {
                                paramValue = new BInteger(((BValueArray)value).getInt((long)i));
                                break;
                            }
                            case 3: {
                                paramValue = new BFloat(((BValueArray)value).getFloat((long)i));
                                break;
                            }
                            case 5: {
                                paramValue = new BString(((BValueArray)value).getString((long)i));
                                break;
                            }
                            case 6: {
                                paramValue = new BBoolean(((BValueArray)value).getBoolean((long)i) > 0);
                                break;
                            }
                            case 20: {
                                BValue array = ((BValueArray)value).getBValue((long)i);
                                if (((BArrayType)value.getType()).getElementType().getTag() == 2) {
                                    paramValue = array;
                                    break;
                                }
                                throw new BallerinaException("unsupported array type for parameter index: " + index + ". Array element type being an array is supported only when the inner array" + " element type is BYTE");
                            }
                            default: {
                                throw new BallerinaException("unsupported array type for parameter index " + index);
                            }
                        }
                        this.bindValue(dataList, (BValue)paramValue, cqlType);
                    }
                    continue;
                }
                this.bindValue(dataList, value, cqlType);
                continue;
            }
            dataList.add(null);
        }
        boundStmt.bind(dataList.toArray());
        return boundStmt;
    }

    private String getCQLType(BMap<String, BValue> parameter) {
        String cqlType = "";
        BValue refType = parameter.get((Object)"cqlType");
        if (refType != null) {
            cqlType = refType.stringValue();
        }
        return cqlType;
    }

    private void bindValue(ArrayList<Object> dataList, BValue value, String csqlType) {
        String cSQLDataType = csqlType.toUpperCase(Locale.getDefault());
        if ("INT".equals(cSQLDataType)) {
            dataList.add(Integer.parseInt(value.stringValue()));
        } else if ("BIGINT".equals(cSQLDataType)) {
            dataList.add(Long.parseLong(value.stringValue()));
        } else if ("VARINT".equals(cSQLDataType)) {
            dataList.add(Float.valueOf(Float.parseFloat(value.stringValue())));
        } else if ("FLOAT".equals(cSQLDataType)) {
            dataList.add(Float.valueOf(Float.parseFloat(value.stringValue())));
        } else if ("DOUBLE".equals(cSQLDataType)) {
            dataList.add(Double.parseDouble(value.stringValue()));
        } else if ("TEXT".equals(cSQLDataType)) {
            dataList.add(value.stringValue());
        } else if ("BOOLEAN".equals(cSQLDataType)) {
            dataList.add(Boolean.parseBoolean(value.stringValue()));
        }
    }
}

