/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.PruneCmd;
import com.github.dockerjava.api.model.PruneResponse;
import com.github.dockerjava.api.model.PruneType;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.github.dockerjava.core.util.FiltersBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PruneCmdImpl
extends AbstrDockerCmd<PruneCmd, PruneResponse>
implements PruneCmd {
    private static final String BUILD_API_PATH = "/build/prune";
    private static final String CONTAINERS_API_PATH = "/containers/prune";
    private static final String IMAGES_API_PATH = "/images/prune";
    private static final String VOLUMES_API_PATH = "/volumes/prune";
    private static final String NETWORKS_API_PATH = "/networks/prune";
    private FiltersBuilder filters = new FiltersBuilder();
    private PruneType pruneType;

    public PruneCmdImpl(PruneCmd.Exec exec, PruneType pruneType) {
        super(exec);
        this.pruneType = pruneType;
    }

    @Override
    @Nonnull
    public PruneType getPruneType() {
        return this.pruneType;
    }

    @Override
    @Nonnull
    public String getApiPath() {
        String apiPath;
        switch (this.getPruneType()) {
            case BUILD: {
                apiPath = BUILD_API_PATH;
                break;
            }
            case IMAGES: {
                apiPath = IMAGES_API_PATH;
                break;
            }
            case NETWORKS: {
                apiPath = NETWORKS_API_PATH;
                break;
            }
            case VOLUMES: {
                apiPath = VOLUMES_API_PATH;
                break;
            }
            default: {
                apiPath = CONTAINERS_API_PATH;
            }
        }
        return apiPath;
    }

    @Override
    @CheckForNull
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    @Override
    public PruneCmd withPruneType(PruneType pruneType) {
        Objects.requireNonNull(pruneType, "pruneType has not been specified");
        this.pruneType = pruneType;
        return this;
    }

    @Override
    public PruneCmd withDangling(Boolean dangling) {
        Objects.requireNonNull(dangling, "dangling has not been specified");
        this.filters.withFilter("dangling", dangling != false ? "1" : "0");
        return this;
    }

    @Override
    public PruneCmd withUntilFilter(String until) {
        Objects.requireNonNull(until, "until has not been specified");
        this.filters.withUntil(until);
        return this;
    }

    @Override
    public PruneCmd withLabelFilter(String ... labels) {
        Objects.requireNonNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public PruneResponse exec() {
        return (PruneResponse)super.exec();
    }
}

