/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.asn1.McEliecePrivateKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import org.bouncycastle.util.Strings;

public class BCMcEliecePrivateKey
implements CipherParameters,
PrivateKey {
    private static final long serialVersionUID = 1L;
    private McEliecePrivateKeyParameters params;

    public BCMcEliecePrivateKey(McEliecePrivateKeyParameters params) {
        this.params = params;
    }

    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public GF2mField getField() {
        return this.params.getField();
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.params.getGoppaPoly();
    }

    public GF2Matrix getSInv() {
        return this.params.getSInv();
    }

    public Permutation getP1() {
        return this.params.getP1();
    }

    public Permutation getP2() {
        return this.params.getP2();
    }

    public GF2Matrix getH() {
        return this.params.getH();
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.params.getQInv();
    }

    public String toString() {
        String result = " length of the code          : " + this.getN() + Strings.lineSeparator();
        result = result + " dimension of the code       : " + this.getK() + Strings.lineSeparator();
        result = result + " irreducible Goppa polynomial: " + this.getGoppaPoly() + Strings.lineSeparator();
        result = result + " permutation P1              : " + this.getP1() + Strings.lineSeparator();
        result = result + " permutation P2              : " + this.getP2() + Strings.lineSeparator();
        result = result + " (k x k)-matrix S^-1         : " + this.getSInv();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BCMcEliecePrivateKey)) {
            return false;
        }
        BCMcEliecePrivateKey otherKey = (BCMcEliecePrivateKey)other;
        return this.getN() == otherKey.getN() && this.getK() == otherKey.getK() && this.getField().equals(otherKey.getField()) && this.getGoppaPoly().equals(otherKey.getGoppaPoly()) && this.getSInv().equals(otherKey.getSInv()) && this.getP1().equals(otherKey.getP1()) && this.getP2().equals(otherKey.getP2());
    }

    public int hashCode() {
        int code = this.params.getK();
        code = code * 37 + this.params.getN();
        code = code * 37 + this.params.getField().hashCode();
        code = code * 37 + this.params.getGoppaPoly().hashCode();
        code = code * 37 + this.params.getP1().hashCode();
        code = code * 37 + this.params.getP2().hashCode();
        return code * 37 + this.params.getSInv().hashCode();
    }

    public byte[] getEncoded() {
        PrivateKeyInfo pki;
        McEliecePrivateKey privateKey = new McEliecePrivateKey(this.params.getN(), this.params.getK(), this.params.getField(), this.params.getGoppaPoly(), this.params.getP1(), this.params.getP2(), this.params.getSInv());
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcEliece);
            pki = new PrivateKeyInfo(algorithmIdentifier, privateKey);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            byte[] encoded = pki.getEncoded();
            return encoded;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

