/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.StreamUtil;

public class DLSequence
extends ASN1Sequence {
    private int bodyLength = -1;

    public DLSequence() {
    }

    public DLSequence(ASN1Encodable element) {
        super(element);
    }

    public DLSequence(ASN1EncodableVector elementVector) {
        super(elementVector);
    }

    public DLSequence(ASN1Encodable[] elements) {
        super(elements);
    }

    DLSequence(ASN1Encodable[] elements, boolean clone) {
        super(elements, clone);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int count = this.elements.length;
            int totalLength = 0;
            for (int i = 0; i < count; ++i) {
                ASN1Primitive dlObject = this.elements[i].toASN1Primitive().toDLObject();
                totalLength += dlObject.encodedLength();
            }
            this.bodyLength = totalLength;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        if (withTag) {
            out.write(48);
        }
        ASN1OutputStream dlOut = out.getDLSubStream();
        int count = this.elements.length;
        if (this.bodyLength >= 0 || count > 16) {
            out.writeLength(this.getBodyLength());
            for (int i = 0; i < count; ++i) {
                dlOut.writePrimitive(this.elements[i].toASN1Primitive(), true);
            }
        } else {
            int i;
            int totalLength = 0;
            ASN1Primitive[] dlObjects = new ASN1Primitive[count];
            for (i = 0; i < count; ++i) {
                ASN1Primitive dlObject;
                dlObjects[i] = dlObject = this.elements[i].toASN1Primitive().toDLObject();
                totalLength += dlObject.encodedLength();
            }
            this.bodyLength = totalLength;
            out.writeLength(totalLength);
            for (i = 0; i < count; ++i) {
                dlOut.writePrimitive(dlObjects[i], true);
            }
        }
    }

    ASN1Primitive toDLObject() {
        return this;
    }
}

