/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.engines.RSACoreEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.BigIntegers;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(boolean forEncryption, CipherParameters parameters) {
        SecureRandom providedRandom = null;
        if (parameters instanceof ParametersWithRandom) {
            ParametersWithRandom withRandom = (ParametersWithRandom)parameters;
            providedRandom = withRandom.getRandom();
            parameters = withRandom.getParameters();
        }
        this.core.init(forEncryption, parameters);
        this.key = (RSAKeyParameters)parameters;
        this.random = this.initSecureRandom(this.key instanceof RSAPrivateCrtKeyParameters, providedRandom);
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger input = this.core.convertInput(in, inOff, inLen);
        BigInteger result = this.processInput(input);
        return this.core.convertOutput(result);
    }

    protected SecureRandom initSecureRandom(boolean needed, SecureRandom provided) {
        return needed ? CryptoServicesRegistrar.getSecureRandom(provided) : null;
    }

    private BigInteger processInput(BigInteger input) {
        RSAPrivateCrtKeyParameters crtKey;
        BigInteger e;
        if (this.key instanceof RSAPrivateCrtKeyParameters && (e = (crtKey = (RSAPrivateCrtKeyParameters)this.key).getPublicExponent()) != null) {
            BigInteger m = crtKey.getModulus();
            BigInteger r = BigIntegers.createRandomInRange(ONE, m.subtract(ONE), this.random);
            BigInteger blind = r.modPow(e, m);
            BigInteger unblind = BigIntegers.modOddInverse(m, r);
            BigInteger blindedInput = blind.multiply(input).mod(m);
            BigInteger blindedResult = this.core.processBlock(blindedInput);
            return unblind.multiply(blindedResult).mod(m);
        }
        return this.core.processBlock(input);
    }
}

