/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecT571R1Point;
import org.bouncycastle.util.encoders.Hex;

public class SecT571R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT571R1_DEFAULT_COORDS = 6;
    protected SecT571R1Point infinity = new SecT571R1Point(this, null, null);
    static final SecT571FieldElement SecT571R1_B = new SecT571FieldElement(new BigInteger(1, Hex.decode("02F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A")));
    static final SecT571FieldElement SecT571R1_B_SQRT = (SecT571FieldElement)SecT571R1_B.sqrt();

    public SecT571R1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = SecT571R1_B;
        this.order = new BigInteger(1, Hex.decode("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B186823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT571R1Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 571;
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT571FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecT571R1Point((ECCurve)this, x, y, withCompression);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecT571R1Point(this, x, y, zs, withCompression);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
        ECFieldElement x = this.fromBigInteger(X1);
        ECFieldElement y = null;
        if (x.isZero()) {
            y = SecT571R1_B_SQRT;
        } else {
            ECFieldElement beta = x.square().invert().multiply(this.b).add(this.a).add(x);
            ECFieldElement z = this.solveQuadraticEquation(beta);
            if (z != null) {
                if (z.testBitZero() != (yTilde == 1)) {
                    z = z.addOne();
                }
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        y = z.add(x);
                        break;
                    }
                    default: {
                        y = z.multiply(x);
                    }
                }
            }
        }
        if (y == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return this.createRawPoint(x, y, true);
    }

    private ECFieldElement solveQuadraticEquation(ECFieldElement beta) {
        if (beta.isZero()) {
            return beta;
        }
        ECFieldElement zeroElement = this.fromBigInteger(ECConstants.ZERO);
        ECFieldElement z = null;
        ECFieldElement gamma = null;
        Random rand = new Random();
        do {
            ECFieldElement t = this.fromBigInteger(new BigInteger(571, rand));
            z = zeroElement;
            ECFieldElement w = beta;
            for (int i = 1; i < 571; ++i) {
                ECFieldElement w2 = w.square();
                z = z.square().add(w2.multiply(t));
                w = w2.add(beta);
            }
            if (w.isZero()) continue;
            return null;
        } while ((gamma = z.square().add(z)).isZero());
        return z;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }
}

