/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCBCModePacketCipher
extends PacketCipher {
    default public void checkParameters(CipherParameters parameters) throws PacketCipherException {
        KeyParameter kp = null;
        if (parameters instanceof KeyParameter) {
            kp = (KeyParameter)parameters;
        } else if (parameters instanceof ParametersWithIV) {
            kp = (KeyParameter)((ParametersWithIV)parameters).getParameters();
            if (((ParametersWithIV)parameters).getIV().length != 16) {
                throw PacketCipherException.from(new IllegalArgumentException("iv must be only 16 bytes"));
            }
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameter type"));
        }
        AESPacketCipher.checkKeyLength(kp.getKeyLength());
    }
}

