/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public interface AESGCMModePacketCipher
extends PacketCipher,
Destroyable {
    default public int checkParameters(CipherParameters params) {
        int macSize;
        KeyParameter keyParam;
        byte[] newNonce;
        CipherParameters param;
        if (params instanceof AEADParameters) {
            param = (AEADParameters)params;
            newNonce = ((AEADParameters)param).getNonce();
            int macSizeBits = ((AEADParameters)param).getMacSize();
            if (macSizeBits < 32 || macSizeBits > 128 || (macSizeBits & 7) != 0) {
                throw new IllegalArgumentException("invalid mac size: " + macSizeBits);
            }
            keyParam = ((AEADParameters)param).getKey();
            macSize = macSizeBits >> 3;
        } else if (params instanceof ParametersWithIV) {
            param = (ParametersWithIV)params;
            newNonce = ((ParametersWithIV)param).getIV();
            keyParam = (KeyParameter)((ParametersWithIV)param).getParameters();
            macSize = 16;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        if (newNonce == null || newNonce.length < 12) {
            throw new IllegalArgumentException("nonce must be at least 12 byte");
        }
        if (keyParam != null) {
            int keyLen = keyParam.getKeyLength();
            if (keyLen < 16 || keyLen > 32 || (keyLen & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        return macSize;
    }
}

