/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.drbg;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.prng.EntropySource;
import org.bouncycastle.crypto.prng.EntropySourceProvider;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;

public class DRBG {
    private static final String PREFIX = DRBG.class.getName();

    private static SecureRandom createBaseRandom(boolean bl) {
        if (Properties.getPropertyValue("org.bouncycastle.drbg.entropysource") != null) {
            EntropySourceProvider entropySourceProvider = DRBG.createEntropySource();
            EntropySource entropySource = entropySourceProvider.get(128);
            byte[] byArray = bl ? DRBG.generateDefaultPersonalizationString(entropySource.getEntropy()) : DRBG.generateNonceIVPersonalizationString(entropySource.getEntropy());
            return new SP800SecureRandomBuilder(entropySourceProvider).setPersonalizationString(byArray).buildHash(SHA512Digest.newInstance(), entropySource.getEntropy(), bl);
        }
        final EntropySourceProvider entropySourceProvider = CryptoServicesRegistrar.getDefaultEntropySourceProvider();
        EntropySource entropySource = entropySourceProvider.get(256);
        byte[] byArray = bl ? DRBG.generateDefaultPersonalizationString(entropySource.getEntropy()) : DRBG.generateNonceIVPersonalizationString(entropySource.getEntropy());
        return new SP800SecureRandomBuilder(new EntropySourceProvider(){

            @Override
            public EntropySource get(int n) {
                return entropySourceProvider.get(n);
            }
        }).setPersonalizationString(byArray).buildHash(SHA512Digest.newInstance(), entropySource.getEntropy(), bl);
    }

    private static EntropySourceProvider createEntropySource() {
        final String string = Properties.getPropertyValue("org.bouncycastle.drbg.entropysource");
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                try {
                    Class clazz = ClassUtil.loadClass(DRBG.class, string);
                    return (EntropySourceProvider)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalStateException("entropy source " + string + " not created: " + exception.getMessage(), exception);
                }
            }
        });
    }

    private static byte[] generateDefaultPersonalizationString(byte[] byArray) {
        return Arrays.concatenate(Strings.toByteArray("Default"), byArray, Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(byte[] byArray) {
        return Arrays.concatenate(Strings.toByteArray("Nonce"), byArray, Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    static /* synthetic */ SecureRandom access$100(boolean bl) {
        return DRBG.createBaseRandom(bl);
    }

    public static class Default
    extends SecureRandomSpi {
        private final SecureRandom random = DRBG.access$100(true);

        @Override
        protected void engineSetSeed(byte[] byArray) {
            this.random.setSeed(byArray);
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            this.random.nextBytes(byArray);
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            return this.random.generateSeed(n);
        }
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            ((BouncyCastleProvider)configurableProvider).setProperty("SecureRandom.DEFAULT ThreadSafe", "true");
            configurableProvider.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            ((BouncyCastleProvider)configurableProvider).setProperty("SecureRandom.NONCEANDIV ThreadSafe", "true");
            configurableProvider.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private final SecureRandom random = DRBG.access$100(false);

        @Override
        protected void engineSetSeed(byte[] byArray) {
            this.random.setSeed(byArray);
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            this.random.nextBytes(byArray);
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            return this.random.generateSeed(n);
        }
    }
}

