/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    TlsServerContextImpl tlsServerContext = null;
    protected int[] offeredCipherSuites = null;
    protected TlsKeyExchange keyExchange = null;
    protected CertificateRequest certificateRequest = null;

    public TlsServerProtocol() {
    }

    public TlsServerProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.tlsServerContext = new TlsServerContextImpl(tlsServer.getCrypto());
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.init(this.tlsServerContext);
        tlsServer.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.offeredCipherSuites = null;
        this.keyExchange = null;
        this.certificateRequest = null;
    }

    protected boolean expectCertificateVerifyMessage() {
        if (null == this.certificateRequest) {
            return false;
        }
        Certificate certificate = this.tlsServerContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && (null == this.keyExchange || this.keyExchange.requiresCertificateVerify());
    }

    protected ServerHello generate13ServerHello(ClientHello clientHello, boolean bl) throws IOException {
        TlsAgreement tlsAgreement;
        int n;
        Object object;
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        TlsCrypto tlsCrypto = this.tlsServerContext.getCrypto();
        Vector vector = TlsExtensionsUtils.getKeyShareClientHello(clientHello.getExtensions());
        KeyShareEntry keyShareEntry = null;
        if (bl) {
            keyShareEntry = null;
            if (null == keyShareEntry) {
                throw new TlsFatalAlert(80);
            }
        } else {
            int[] nArray;
            if (null == vector || vector.isEmpty() || (keyShareEntry = TlsUtils.selectKeyShare(tlsCrypto, protocolVersion, vector, nArray = securityParameters.getClientSupportedGroups(), (int[])(object = securityParameters.getServerSupportedGroups()))) == null || keyShareEntry.getNamedGroup() != object[0]) {
                // empty if block
            }
            if (null == keyShareEntry) {
                throw new TlsFatalAlert(80);
            }
        }
        this.clientExtensions = clientHello.getExtensions();
        securityParameters.secureRenegotiation = false;
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
            TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
        if (null == securityParameters.getClientSigAlgs()) {
            throw new TlsFatalAlert(109);
        }
        this.invalidateSession();
        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
        TlsUtils.negotiatedVersionTLSServer(this.tlsServerContext);
        securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(false, this.tlsServerContext);
        if (!protocolVersion.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getProtocolVersions()))) {
            TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        if (!TlsUtils.isValidCipherSuiteSelection(this.offeredCipherSuites, n = this.tlsServer.getSelectedCipherSuite()) || !TlsUtils.isValidVersionForCipherSuite(n, protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        Hashtable hashtable = new Hashtable();
        object = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsServer.getServerExtensions());
        ProtocolVersion protocolVersion2 = ProtocolVersion.TLSv12;
        TlsExtensionsUtils.addSupportedVersionsExtensionServer(hashtable, protocolVersion);
        securityParameters.extendedMasterSecret = true;
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer((Hashtable)object);
        securityParameters.applicationProtocolSet = true;
        if (!((Hashtable)object).isEmpty()) {
            // empty if block
        }
        securityParameters.encryptThenMAC = false;
        securityParameters.truncatedHMac = false;
        securityParameters.statusRequestVersion = 1;
        this.expectSessionTicket = false;
        int n2 = keyShareEntry.getNamedGroup();
        if (NamedGroup.refersToASpecificCurve(n2)) {
            tlsAgreement = tlsCrypto.createECDomain(new TlsECConfig(n2)).createECDH();
        } else if (NamedGroup.refersToASpecificFiniteField(n2)) {
            tlsAgreement = tlsCrypto.createDHDomain(new TlsDHConfig(n2, true)).createDH();
        } else {
            throw new TlsFatalAlert(80);
        }
        byte[] byArray = tlsAgreement.generateEphemeral();
        KeyShareEntry keyShareEntry2 = new KeyShareEntry(n2, byArray);
        TlsExtensionsUtils.addKeyShareServerHello(hashtable, keyShareEntry2);
        tlsAgreement.receivePeerValue(keyShareEntry.getKeyExchange());
        securityParameters.sharedSecret = tlsAgreement.calculateSecret();
        TlsUtils.establish13PhaseSecrets(this.tlsServerContext);
        this.serverExtensions = object;
        return new ServerHello(protocolVersion2, securityParameters.getServerRandom(), this.tlsSession.getSessionID(), securityParameters.getCipherSuite(), hashtable);
    }

    protected ServerHello generateServerHello(ClientHello clientHello) throws IOException {
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2 = clientHello.getVersion();
        if (!protocolVersion2.isTLS()) {
            throw new TlsFatalAlert(47);
        }
        this.offeredCipherSuites = clientHello.getCipherSuites();
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        this.tlsServerContext.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(clientHello.getExtensions()));
        ProtocolVersion protocolVersion3 = protocolVersion2;
        if (null == this.tlsServerContext.getClientSupportedVersions()) {
            if (protocolVersion3.isLaterVersionOf(ProtocolVersion.TLSv12)) {
                protocolVersion3 = ProtocolVersion.TLSv12;
            }
            this.tlsServerContext.setClientSupportedVersions(protocolVersion3.downTo(ProtocolVersion.SSLv3));
        } else {
            protocolVersion3 = ProtocolVersion.getLatestTLS(this.tlsServerContext.getClientSupportedVersions());
        }
        this.recordStream.setWriteVersion(protocolVersion3);
        if (!ProtocolVersion.SERVER_EARLIEST_SUPPORTED_TLS.isEqualOrEarlierVersionOf(protocolVersion3)) {
            throw new TlsFatalAlert(70);
        }
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion3.equals(this.tlsServerContext.getClientVersion()) && !protocolVersion3.equals(this.tlsServerContext.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            this.tlsServerContext.setClientVersion(protocolVersion3);
        }
        this.tlsServer.notifyClientVersion(this.tlsServerContext.getClientVersion());
        securityParameters.clientRandom = clientHello.getRandom();
        this.tlsServer.notifyFallback(Arrays.contains((int[])this.offeredCipherSuites, (int)22016));
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        if (securityParameters.isRenegotiating()) {
            protocolVersion = this.tlsServerContext.getServerVersion();
        } else {
            protocolVersion = this.tlsServer.getServerVersion();
            if (!ProtocolVersion.contains(this.tlsServerContext.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.negotiatedVersion = protocolVersion;
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientHello.getExtensions());
        securityParameters.serverSupportedGroups = this.tlsServer.getSupportedGroups();
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion)) {
            this.recordStream.setIgnoreChangeCipherSpec(true);
            this.recordStream.setWriteVersion(ProtocolVersion.TLSv12);
            return this.generate13ServerHello(clientHello, false);
        }
        this.recordStream.setWriteVersion(protocolVersion);
        this.clientExtensions = clientHello.getExtensions();
        byte[] byArray = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                throw new TlsFatalAlert(40);
            }
            if (null == byArray) {
                throw new TlsFatalAlert(40);
            }
            SecurityParameters securityParameters2 = this.tlsServerContext.getSecurityParametersConnection();
            byte[] byArray2 = securityParameters2.getPeerVerifyData();
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])TlsServerProtocol.createRenegotiationInfo(byArray2))) {
                throw new TlsFatalAlert(40);
            }
        } else {
            if (Arrays.contains((int[])this.offeredCipherSuites, (int)255)) {
                securityParameters.secureRenegotiation = true;
            }
            if (byArray != null) {
                securityParameters.secureRenegotiation = true;
                if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
        }
        this.tlsServer.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions);
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion3)) {
                TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
        this.invalidateSession();
        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
        TlsUtils.negotiatedVersionTLSServer(this.tlsServerContext);
        int n = this.tlsServer.shouldUseGMTUnixTime();
        securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(n != 0, this.tlsServerContext);
        if (!protocolVersion.equals(ProtocolVersion.getLatestTLS(this.tlsServer.getProtocolVersions()))) {
            TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        if (!TlsUtils.isValidCipherSuiteSelection(this.offeredCipherSuites, n = this.tlsServer.getSelectedCipherSuite()) || !TlsUtils.isValidVersionForCipherSuite(n, protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        this.tlsServerContext.setRSAPreMasterSecretVersion(protocolVersion2);
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsServer.getServerExtensions());
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            SecurityParameters securityParameters3 = this.tlsServerContext.getSecurityParametersConnection();
            byte[] byArray3 = TlsUtils.concat(securityParameters3.getPeerVerifyData(), securityParameters3.getLocalVerifyData());
            this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(byArray3));
        } else if (securityParameters.isSecureRenegotiation()) {
            boolean bl2;
            byte[] byArray4 = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl3 = bl2 = null == byArray4;
            if (bl2) {
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        boolean bl4 = securityParameters.extendedMasterSecret = bl && !protocolVersion.isSSL() && this.tlsServer.shouldUseExtendedMasterSecret();
        if (securityParameters.isExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        } else {
            if (this.tlsServer.requiresExtendedMasterSecret()) {
                throw new TlsFatalAlert(40);
            }
            if (this.resumedSession && !this.tlsServer.allowLegacyResumption()) {
                throw new TlsFatalAlert(80);
            }
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        if (!this.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            if (!this.resumedSession) {
                if (TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.statusRequestVersion = 1;
                }
            }
            this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
        }
        this.applyMaxFragmentLengthExtension();
        return new ServerHello(protocolVersion, securityParameters.getServerRandom(), this.tlsSession.getSessionID(), securityParameters.getCipherSuite(), this.serverExtensions);
    }

    @Override
    protected TlsContext getContext() {
        return this.tlsServerContext;
    }

    @Override
    AbstractTlsContext getContextAdmin() {
        return this.tlsServerContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    protected void handle13HandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 20: {
                        this.receive13ClientCertificate(handshakeMessageInput);
                        this.connection_state = (short)15;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 15: {
                        this.receive13ClientCertificateVerify(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)17;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        throw new TlsFatalAlert(80);
                    }
                    case 2: {
                        ClientHello clientHello = this.receiveClientHelloMessage(handshakeMessageInput);
                        this.connection_state = (short)3;
                        ServerHello serverHello = this.generate13ServerHello(clientHello, true);
                        this.sendServerHelloMessage(serverHello);
                        this.connection_state = (short)4;
                        this.send13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 20: {
                        this.skip13ClientCertificate();
                    }
                    case 15: {
                        this.skip13ClientCertificateVerify();
                    }
                    case 17: {
                        this.receive13ClientFinished(handshakeMessageInput);
                        this.connection_state = (short)18;
                        this.recordStream.setIgnoreChangeCipherSpec(false);
                        this.recordStream.enablePendingCipherRead(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                switch (this.connection_state) {
                    case 21: {
                        this.receive13ClientKeyUpdate(handshakeMessageInput);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleHandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            this.handle13HandshakeMessage(s, handshakeMessageInput);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (s) {
            case 1: {
                switch (this.connection_state) {
                    case 21: {
                        if (!this.handleRenegotiation()) break block0;
                    }
                    case 0: {
                        ClientHello clientHello = this.receiveClientHelloMessage(handshakeMessageInput);
                        this.connection_state = 1;
                        ServerHello serverHello = this.generateServerHello(clientHello);
                        this.handshakeHash.notifyPRFDetermined();
                        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
                            if (serverHello.isHelloRetryRequest()) {
                                TlsUtils.adjustTranscriptForRetry(this.handshakeHash);
                                this.sendServerHelloMessage(serverHello);
                                this.connection_state = (short)2;
                                this.sendChangeCipherSpecMessage();
                                break block0;
                            }
                            this.sendServerHelloMessage(serverHello);
                            this.connection_state = (short)4;
                            this.sendChangeCipherSpecMessage();
                            this.send13ServerHelloCoda(serverHello, false);
                            break block0;
                        }
                        this.sendServerHelloMessage(serverHello);
                        this.connection_state = (short)4;
                        Vector vector = this.tlsServer.getServerSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                            this.connection_state = (short)6;
                        }
                        this.keyExchange = TlsUtils.initKeyExchangeServer(this.tlsServerContext, this.tlsServer);
                        TlsCredentials tlsCredentials = TlsUtils.establishServerCredentials(this.tlsServer);
                        Object object = null;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        if (null == tlsCredentials) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(tlsCredentials);
                            object = tlsCredentials.getCertificate();
                            this.sendCertificateMessage((Certificate)object, byteArrayOutputStream);
                            this.connection_state = (short)7;
                        }
                        securityParameters.tlsServerEndPoint = byteArrayOutputStream.toByteArray();
                        if (null == object || ((Certificate)object).isEmpty()) {
                            securityParameters.statusRequestVersion = 0;
                        }
                        if (securityParameters.getStatusRequestVersion() > 0 && (object = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage((CertificateStatus)object);
                            this.connection_state = (short)8;
                        }
                        if ((object = (Object)this.keyExchange.generateServerKeyExchange()) != null) {
                            this.sendServerKeyExchangeMessage((byte[])object);
                            this.connection_state = (short)10;
                        }
                        if (null != tlsCredentials) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (null == this.certificateRequest) {
                                if (!this.keyExchange.requiresCertificateVerify()) {
                                    throw new TlsFatalAlert(80);
                                }
                            } else {
                                if (TlsUtils.isTLSv12(this.tlsServerContext) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                                TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                                TlsUtils.trackHashAlgorithms(this.handshakeHash, securityParameters.getServerSigAlgs());
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                this.connection_state = (short)11;
                            }
                        }
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)12;
                        boolean bl = false;
                        TlsUtils.sealHandshakeHash(this.tlsServerContext, this.handshakeHash, bl);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(handshakeMessageInput));
                        this.connection_state = (short)14;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 14: {
                        if (this.certificateRequest == null) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateMessage(handshakeMessageInput);
                        this.connection_state = (short)15;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 12: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 14: {
                        if (null == this.certificateRequest) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            if (TlsUtils.isTLSv12(this.tlsServerContext)) {
                                throw new TlsFatalAlert(10);
                            }
                            if (TlsUtils.isSSL(this.tlsServerContext)) {
                                throw new TlsFatalAlert(10);
                            }
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
                    case 15: {
                        this.receiveClientKeyExchangeMessage(handshakeMessageInput);
                        this.connection_state = (short)16;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 16: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)17;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 16: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 17: {
                        this.processFinishedMessage(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)18;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                            this.connection_state = (short)19;
                        }
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleAlertWarningMessage(short s) throws IOException {
        if (41 == s && null != this.certificateRequest && TlsUtils.isSSL(this.tlsServerContext)) {
            switch (this.connection_state) {
                case 12: {
                    this.tlsServer.processClientSupplementalData(null);
                }
                case 14: {
                    this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                    this.connection_state = (short)15;
                    return;
                }
            }
        }
        super.handleAlertWarningMessage(s);
    }

    protected void notifyClientCertificate(Certificate certificate) throws IOException {
        if (null == this.certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.processClientCertificate(this.tlsServerContext, certificate, this.keyExchange, this.tlsServer);
    }

    protected void receive13ClientCertificate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = Certificate.parse(this.tlsServerContext, byteArrayInputStream, null);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receive13ClientCertificateVerify(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = this.tlsServerContext.getSecurityParametersHandshake().getPeerCertificate();
        if (null == certificate || certificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        DigitallySigned digitallySigned = DigitallySigned.parse(this.tlsServerContext, byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verify13CertificateVerifyClient(this.tlsServerContext, this.certificateRequest, digitallySigned, this.handshakeHash);
    }

    protected void receive13ClientFinished(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.processFinishedMessage(byteArrayInputStream);
    }

    protected void receive13ClientKeyUpdate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = Certificate.parse(this.tlsServerContext, byteArrayInputStream, null);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        DigitallySigned digitallySigned = DigitallySigned.parse(this.tlsServerContext, byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verifyCertificateVerifyClient(this.tlsServerContext, this.certificateRequest, digitallySigned, this.handshakeHash);
        this.handshakeHash = this.handshakeHash.stopTracking();
    }

    protected ClientHello receiveClientHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        return ClientHello.parse(byteArrayInputStream, null);
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        boolean bl = TlsUtils.isSSL(this.tlsServerContext);
        if (bl) {
            TlsServerProtocol.establishMasterSecret(this.tlsServerContext, this.keyExchange);
        }
        this.tlsServerContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        if (!bl) {
            TlsServerProtocol.establishMasterSecret(this.tlsServerContext, this.keyExchange);
        }
        this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsServerContext));
        if (!this.expectCertificateVerifyMessage()) {
            this.handshakeHash = this.handshakeHash.stopTracking();
        }
    }

    protected void send13EncryptedExtensionsMessage(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsServerProtocol.writeExtensionsData(hashtable);
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(8);
        TlsUtils.writeOpaque16(byArray, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void send13ServerHelloCoda(ServerHello serverHello, boolean bl) throws IOException {
        TlsCredentialedSigner tlsCredentialedSigner;
        SecurityParameters securityParameters = this.tlsServerContext.getSecurityParametersHandshake();
        byte[] byArray = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseHandshake(this.tlsServerContext, byArray, this.recordStream);
        this.recordStream.enablePendingCipherWrite();
        this.recordStream.enablePendingCipherRead(true);
        this.send13EncryptedExtensionsMessage(this.serverExtensions);
        this.connection_state = (short)5;
        this.certificateRequest = this.tlsServer.getCertificateRequest();
        if (null != this.certificateRequest) {
            if (!this.certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
                throw new TlsFatalAlert(80);
            }
            TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
            this.sendCertificateRequestMessage(this.certificateRequest);
            this.connection_state = (short)11;
        }
        if (null == (tlsCredentialedSigner = TlsUtils.establish13ServerCredentials(this.tlsServer))) {
            throw new TlsFatalAlert(80);
        }
        Object object = new ByteArrayOutputStream();
        Certificate certificate = tlsCredentialedSigner.getCertificate();
        this.send13CertificateMessage(certificate, (OutputStream)object);
        securityParameters.tlsServerEndPoint = ((ByteArrayOutputStream)object).toByteArray();
        securityParameters.statusRequestVersion = 1;
        this.connection_state = (short)7;
        object = TlsUtils.generate13CertificateVerify(this.tlsServerContext, tlsCredentialedSigner, this.handshakeHash);
        this.send13CertificateVerifyMessage((DigitallySigned)object);
        this.connection_state = (short)17;
        this.send13FinishedMessage();
        this.connection_state = (short)20;
        object = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseApplication(this.tlsServerContext, (byte[])object, this.recordStream);
        this.recordStream.enablePendingCipherWrite();
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(13);
        certificateRequest.encode(this.tlsServerContext, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(22);
        certificateStatus.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendHelloRequestMessage() throws IOException {
        HandshakeMessageOutput.send(this, (short)0, TlsUtils.EMPTY_BYTES);
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(4);
        newSessionTicket.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        HandshakeMessageOutput.send(this, (short)14, TlsUtils.EMPTY_BYTES);
    }

    protected void sendServerHelloMessage(ServerHello serverHello) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(2);
        serverHello.encode(this.tlsServerContext, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendServerKeyExchangeMessage(byte[] byArray) throws IOException {
        HandshakeMessageOutput.send(this, (short)12, byArray);
    }

    protected void skip13ClientCertificate() throws IOException {
        if (null != this.certificateRequest) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void skip13ClientCertificateVerify() throws IOException {
        if (this.expectCertificateVerifyMessage()) {
            throw new TlsFatalAlert(10);
        }
    }
}

