/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class BCSSLParameters {
    private String[] applicationProtocols = new String[0];
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private String endpointIdentificationAlgorithm;
    private BCAlgorithmConstraints algorithmConstraints;
    private List<BCSNIServerName> serverNames;
    private List<BCSNIMatcher> sniMatchers;
    private boolean useCipherSuitesOrder;

    private static String[] clone(String[] a) {
        return a == null ? null : (String[])a.clone();
    }

    private static <T> List<T> copyList(Collection<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public BCSSLParameters() {
    }

    public BCSSLParameters(String[] cipherSuites) {
        this.setCipherSuites(cipherSuites);
    }

    public BCSSLParameters(String[] cipherSuites, String[] protocols) {
        this.setCipherSuites(cipherSuites);
        this.setProtocols(protocols);
    }

    public String[] getApplicationProtocols() {
        return (String[])this.applicationProtocols.clone();
    }

    public void setApplicationProtocols(String[] applicationProtocols) {
        String[] check;
        if (null == applicationProtocols) {
            throw new NullPointerException("'applicationProtocols' cannot be null");
        }
        for (String entry : check = (String[])applicationProtocols.clone()) {
            if (null != entry && entry.length() >= 1) continue;
            throw new IllegalArgumentException("'applicationProtocols' entries cannot be null or empty strings");
        }
        this.applicationProtocols = check;
    }

    public String[] getCipherSuites() {
        return BCSSLParameters.clone(this.cipherSuites);
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = BCSSLParameters.clone(cipherSuites);
    }

    public String[] getProtocols() {
        return BCSSLParameters.clone(this.protocols);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = BCSSLParameters.clone(protocols);
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = false;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = false;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public BCAlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(BCAlgorithmConstraints algorithmConstraints) {
        this.algorithmConstraints = algorithmConstraints;
    }

    public void setServerNames(List<BCSNIServerName> serverNames) {
        if (serverNames == null) {
            this.serverNames = null;
        } else {
            List<BCSNIServerName> copy = BCSSLParameters.copyList(serverNames);
            HashSet<Integer> types = new HashSet<Integer>();
            for (BCSNIServerName serverName : copy) {
                int type = serverName.getType();
                if (types.add(type)) continue;
                throw new IllegalArgumentException("Found duplicate SNI server name entry of type " + type);
            }
            this.serverNames = copy;
        }
    }

    public List<BCSNIServerName> getServerNames() {
        return BCSSLParameters.copyList(this.serverNames);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> sniMatchers) {
        if (sniMatchers == null) {
            this.sniMatchers = null;
        } else {
            List<BCSNIMatcher> copy = BCSSLParameters.copyList(sniMatchers);
            HashSet<Integer> types = new HashSet<Integer>();
            for (BCSNIMatcher sniMatcher : copy) {
                int type = sniMatcher.getType();
                if (types.add(type)) continue;
                throw new IllegalArgumentException("Found duplicate SNI matcher entry of type " + type);
            }
            this.sniMatchers = copy;
        }
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return BCSSLParameters.copyList(this.sniMatchers);
    }

    public void setUseCipherSuitesOrder(boolean useCipherSuitesOrder) {
        this.useCipherSuitesOrder = useCipherSuitesOrder;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }
}

