/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.ProvX509KeyManagerSimple;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private static final Logger LOG = Logger.getLogger(ProvKeyManagerFactorySpi.class.getName());
    protected final JcaJceHelper helper;
    protected BCX509ExtendedKeyManager x509KeyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStoreConfig getDefaultKeyStore() throws Exception {
        String defaultType = KeyStore.getDefaultType();
        String ksPath = null;
        char[] ksPassword = null;
        String ksPathProp = PropertyUtils.getSystemProperty("javax.net.ssl.keyStore");
        if (!"NONE".equals(ksPathProp) && null != ksPathProp && new File(ksPathProp).exists()) {
            ksPath = ksPathProp;
        }
        KeyStore ks = ProvKeyManagerFactorySpi.createKeyStore(defaultType);
        String ksPasswordProp = PropertyUtils.getSystemProperty("javax.net.ssl.keyStorePassword");
        if (null != ksPasswordProp) {
            ksPassword = ksPasswordProp.toCharArray();
        }
        InputStream ksInput = null;
        try {
            if (null == ksPath) {
                LOG.info("Initializing empty key store");
            } else {
                LOG.info("Initializing with key store at path: " + ksPath);
                ksInput = new BufferedInputStream(new FileInputStream(ksPath));
            }
            ks.load(ksInput, ksPassword);
        }
        finally {
            if (null != ksInput) {
                ksInput.close();
            }
        }
        return new KeyStoreConfig(ks, ksPassword);
    }

    ProvKeyManagerFactorySpi(JcaJceHelper helper) {
        this.helper = helper;
    }

    protected KeyManager[] engineGetKeyManagers() {
        if (null == this.x509KeyManager) {
            throw new IllegalStateException("KeyManagerFactory not initialized");
        }
        return new KeyManager[]{this.x509KeyManager};
    }

    protected void engineInit(KeyStore ks, char[] ksPassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.x509KeyManager = new ProvX509KeyManagerSimple(this.helper, ks, ksPassword);
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (!(managerFactoryParameters instanceof KeyStoreBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
        }
        List<KeyStore.Builder> builders = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
        this.x509KeyManager = new ProvX509KeyManager(this.helper, builders);
    }

    private static KeyStore createKeyStore(String defaultType) throws NoSuchProviderException, KeyStoreException {
        String ksType = ProvKeyManagerFactorySpi.getKeyStoreType(defaultType);
        String ksProv = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreProvider");
        return null == ksProv || ksProv.length() < 1 ? KeyStore.getInstance(ksType) : KeyStore.getInstance(ksType, ksProv);
    }

    private static String getKeyStoreType(String defaultType) {
        String ksType = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreType");
        return null == ksType ? defaultType : ksType;
    }
}

