/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.CertificateEntry;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Certificate {
    private static final TlsCertificate[] EMPTY_CERTS = new TlsCertificate[0];
    private static final CertificateEntry[] EMPTY_CERT_ENTRIES = new CertificateEntry[0];
    public static final Certificate EMPTY_CHAIN = new Certificate(EMPTY_CERTS);
    public static final Certificate EMPTY_CHAIN_TLS13 = new Certificate(TlsUtils.EMPTY_BYTES, EMPTY_CERT_ENTRIES);
    protected final byte[] certificateRequestContext;
    protected final CertificateEntry[] certificateEntryList;

    private static CertificateEntry[] convert(TlsCertificate[] certificateList) {
        if (TlsUtils.isNullOrContainsNull(certificateList)) {
            throw new NullPointerException("'certificateList' cannot be null or contain any nulls");
        }
        int count = certificateList.length;
        CertificateEntry[] result = new CertificateEntry[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new CertificateEntry(certificateList[i], null);
        }
        return result;
    }

    public Certificate(TlsCertificate[] certificateList) {
        this(null, Certificate.convert(certificateList));
    }

    public Certificate(byte[] certificateRequestContext, CertificateEntry[] certificateEntryList) {
        if (null != certificateRequestContext && !TlsUtils.isValidUint8(certificateRequestContext.length)) {
            throw new IllegalArgumentException("'certificateRequestContext' cannot be longer than 255");
        }
        if (TlsUtils.isNullOrContainsNull(certificateEntryList)) {
            throw new NullPointerException("'certificateEntryList' cannot be null or contain any nulls");
        }
        this.certificateRequestContext = TlsUtils.clone(certificateRequestContext);
        this.certificateEntryList = certificateEntryList;
    }

    public byte[] getCertificateRequestContext() {
        return TlsUtils.clone(this.certificateRequestContext);
    }

    public TlsCertificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public TlsCertificate getCertificateAt(int index) {
        return this.certificateEntryList[index].getCertificate();
    }

    public CertificateEntry getCertificateEntryAt(int index) {
        return this.certificateEntryList[index];
    }

    public CertificateEntry[] getCertificateEntryList() {
        return this.cloneCertificateEntryList();
    }

    public short getCertificateType() {
        return 0;
    }

    public int getLength() {
        return this.certificateEntryList.length;
    }

    public boolean isEmpty() {
        return this.certificateEntryList.length == 0;
    }

    public void encode(TlsContext context, OutputStream messageOutput, OutputStream endPointHashOutput) throws IOException {
        int i;
        boolean isTLSv13;
        if (null != this.certificateRequestContext != (isTLSv13 = TlsUtils.isTLSv13(context))) {
            throw new IllegalStateException();
        }
        if (isTLSv13) {
            TlsUtils.writeOpaque8(this.certificateRequestContext, messageOutput);
        }
        int count = this.certificateEntryList.length;
        Vector<byte[]> certEncodings = new Vector<byte[]>(count);
        Vector<byte[]> extEncodings = isTLSv13 ? new Vector<byte[]>(count) : null;
        long totalLength = 0L;
        for (i = 0; i < count; ++i) {
            CertificateEntry entry = this.certificateEntryList[i];
            TlsCertificate cert = entry.getCertificate();
            byte[] derEncoding = cert.getEncoded();
            if (i == 0 && endPointHashOutput != null) {
                Certificate.calculateEndPointHash(context, cert, derEncoding, endPointHashOutput);
            }
            certEncodings.addElement(derEncoding);
            totalLength += (long)derEncoding.length;
            totalLength += 3L;
            if (!isTLSv13) continue;
            Hashtable extensions = entry.getExtensions();
            byte[] extEncoding = null == extensions ? TlsUtils.EMPTY_BYTES : TlsProtocol.writeExtensionsData(extensions);
            extEncodings.addElement(extEncoding);
            totalLength += (long)extEncoding.length;
            totalLength += 2L;
        }
        TlsUtils.checkUint24(totalLength);
        TlsUtils.writeUint24((int)totalLength, messageOutput);
        for (i = 0; i < count; ++i) {
            byte[] certEncoding = (byte[])certEncodings.elementAt(i);
            TlsUtils.writeOpaque24(certEncoding, messageOutput);
            if (!isTLSv13) continue;
            byte[] extEncoding = (byte[])extEncodings.elementAt(i);
            TlsUtils.writeOpaque16(extEncoding, messageOutput);
        }
    }

    public static Certificate parse(TlsContext context, InputStream messageInput, OutputStream endPointHashOutput) throws IOException {
        int totalLength;
        boolean isTLSv13 = TlsUtils.isTLSv13(context);
        byte[] certificateRequestContext = null;
        if (isTLSv13) {
            certificateRequestContext = TlsUtils.readOpaque8(messageInput);
        }
        if ((totalLength = TlsUtils.readUint24(messageInput)) == 0) {
            return !isTLSv13 ? EMPTY_CHAIN : (certificateRequestContext.length < 1 ? EMPTY_CHAIN_TLS13 : new Certificate(certificateRequestContext, EMPTY_CERT_ENTRIES));
        }
        byte[] certListData = TlsUtils.readFully(totalLength, messageInput);
        ByteArrayInputStream buf = new ByteArrayInputStream(certListData);
        Vector<CertificateEntry> certificate_list = new Vector<CertificateEntry>();
        while (buf.available() > 0) {
            byte[] derEncoding = TlsUtils.readOpaque24(buf, 1);
            TlsCertificate cert = context.getCrypto().createCertificate(derEncoding);
            if (certificate_list.isEmpty() && endPointHashOutput != null) {
                Certificate.calculateEndPointHash(context, cert, derEncoding, endPointHashOutput);
            }
            Hashtable extensions = null;
            if (isTLSv13) {
                byte[] extEncoding = TlsUtils.readOpaque16(buf);
                extensions = TlsProtocol.readExtensionsData(extEncoding);
            }
            certificate_list.addElement(new CertificateEntry(cert, extensions));
        }
        CertificateEntry[] certificateList = new CertificateEntry[certificate_list.size()];
        for (int i = 0; i < certificate_list.size(); ++i) {
            certificateList[i] = (CertificateEntry)certificate_list.elementAt(i);
        }
        return new Certificate(certificateRequestContext, certificateList);
    }

    protected static void calculateEndPointHash(TlsContext context, TlsCertificate cert, byte[] encoding, OutputStream output) throws IOException {
        byte[] endPointHash = TlsUtils.calculateEndPointHash(context, cert, encoding);
        if (endPointHash != null && endPointHash.length > 0) {
            output.write(endPointHash);
        }
    }

    protected TlsCertificate[] cloneCertificateList() {
        int count = this.certificateEntryList.length;
        if (0 == count) {
            return EMPTY_CERTS;
        }
        TlsCertificate[] result = new TlsCertificate[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.certificateEntryList[i].getCertificate();
        }
        return result;
    }

    protected CertificateEntry[] cloneCertificateEntryList() {
        int count = this.certificateEntryList.length;
        if (0 == count) {
            return EMPTY_CERT_ENTRIES;
        }
        CertificateEntry[] result = new CertificateEntry[count];
        System.arraycopy(this.certificateEntryList, 0, result, 0, count);
        return result;
    }
}

