/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CertificateStatus {
    protected short statusType;
    protected Object response;

    public CertificateStatus(short statusType, Object response) {
        if (!CertificateStatus.isCorrectType(statusType, response)) {
            throw new IllegalArgumentException("'response' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.response = response;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getResponse() {
        return this.response;
    }

    public OCSPResponse getOCSPResponse() {
        if (!CertificateStatus.isCorrectType((short)1, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponse");
        }
        return (OCSPResponse)this.response;
    }

    public Vector getOCSPResponseList() {
        if (!CertificateStatus.isCorrectType((short)2, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponseList");
        }
        return (Vector)this.response;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        switch (this.statusType) {
            case 1: {
                OCSPResponse ocspResponse = (OCSPResponse)this.response;
                byte[] derEncoding = ocspResponse.getEncoded("DER");
                TlsUtils.writeOpaque24(derEncoding, output);
                break;
            }
            case 2: {
                int i;
                Vector ocspResponseList = (Vector)this.response;
                int count = ocspResponseList.size();
                Vector<byte[]> derEncodings = new Vector<byte[]>(count);
                long totalLength = 0L;
                for (i = 0; i < count; ++i) {
                    OCSPResponse ocspResponse = (OCSPResponse)ocspResponseList.elementAt(i);
                    if (ocspResponse == null) {
                        derEncodings.addElement(TlsUtils.EMPTY_BYTES);
                    } else {
                        byte[] derEncoding = ocspResponse.getEncoded("DER");
                        derEncodings.addElement(derEncoding);
                        totalLength += (long)derEncoding.length;
                    }
                    totalLength += 3L;
                }
                TlsUtils.checkUint24(totalLength);
                TlsUtils.writeUint24((int)totalLength, output);
                for (i = 0; i < count; ++i) {
                    byte[] derEncoding = (byte[])derEncodings.elementAt(i);
                    TlsUtils.writeOpaque24(derEncoding, output);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatus parse(TlsContext context, InputStream input) throws IOException {
        Object response;
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        Certificate peerCertificate = securityParameters.getPeerCertificate();
        if (null == peerCertificate || peerCertificate.isEmpty() || 0 != peerCertificate.getCertificateType()) {
            throw new TlsFatalAlert(80);
        }
        int certificateCount = peerCertificate.getLength();
        int statusRequestVersion = securityParameters.getStatusRequestVersion();
        short status_type = TlsUtils.readUint8(input);
        switch (status_type) {
            case 1: {
                CertificateStatus.requireStatusRequestVersion(1, statusRequestVersion);
                byte[] derEncoding = TlsUtils.readOpaque24(input, 1);
                ASN1Primitive derObject = TlsUtils.readDERObject(derEncoding);
                response = OCSPResponse.getInstance((Object)derObject);
                break;
            }
            case 2: {
                CertificateStatus.requireStatusRequestVersion(2, statusRequestVersion);
                byte[] ocsp_response_list = TlsUtils.readOpaque24(input, 1);
                ByteArrayInputStream buf = new ByteArrayInputStream(ocsp_response_list);
                Vector<OCSPResponse> ocspResponseList = new Vector<OCSPResponse>();
                while (buf.available() > 0) {
                    if (ocspResponseList.size() >= certificateCount) {
                        throw new TlsFatalAlert(47);
                    }
                    int length = TlsUtils.readUint24(buf);
                    if (length < 1) {
                        ocspResponseList.addElement(null);
                        continue;
                    }
                    byte[] derEncoding = TlsUtils.readFully(length, (InputStream)buf);
                    ASN1Primitive derObject = TlsUtils.readDERObject(derEncoding);
                    OCSPResponse ocspResponse = OCSPResponse.getInstance((Object)derObject);
                    ocspResponseList.addElement(ocspResponse);
                }
                ocspResponseList.trimToSize();
                response = ocspResponseList;
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatus(status_type, response);
    }

    protected static boolean isCorrectType(short statusType, Object response) {
        switch (statusType) {
            case 1: {
                return response instanceof OCSPResponse;
            }
            case 2: {
                return CertificateStatus.isOCSPResponseList(response);
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }

    protected static boolean isOCSPResponseList(Object response) {
        if (!(response instanceof Vector)) {
            return false;
        }
        Vector v = (Vector)response;
        int count = v.size();
        if (count < 1) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Object e = v.elementAt(i);
            if (null == e || e instanceof OCSPResponse) continue;
            return false;
        }
        return true;
    }

    protected static void requireStatusRequestVersion(int minVersion, int statusRequestVersion) throws IOException {
        if (statusRequestVersion < minVersion) {
            throw new TlsFatalAlert(50);
        }
    }
}

