/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TlsRSAUtils {
    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext context, TlsCertificate certificate, OutputStream output) throws IOException {
        TlsSecret preMasterSecret = context.getCrypto().generateRSAPreMasterSecret(context.getRSAPreMasterSecretVersion());
        byte[] encryptedPreMasterSecret = preMasterSecret.encrypt(certificate);
        TlsUtils.writeEncryptedPMS(context, encryptedPreMasterSecret, output);
        return preMasterSecret;
    }
}

