/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.MACAlgorithm;
import org.bouncycastle.tls.PRFAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TlsCryptoUtils {
    private static final byte[] TLS13_PREFIX = new byte[]{116, 108, 115, 49, 51, 32};

    public static int getHash(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified HashAlgorithm invalid: " + HashAlgorithm.getText(hashAlgorithm));
    }

    public static int getHashForHMAC(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new IllegalArgumentException("specified MACAlgorithm not an HMAC: " + MACAlgorithm.getText(macAlgorithm));
    }

    public static int getHashForPRF(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 2: 
            case 4: {
                return 4;
            }
            case 3: 
            case 5: {
                return 5;
            }
            case 7: {
                return 7;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(prfAlgorithm));
    }

    public static int getHashOutputSize(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return 16;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 28;
            }
            case 4: 
            case 7: {
                return 32;
            }
            case 5: {
                return 48;
            }
            case 6: {
                return 64;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getSignature(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 64: {
                return 64;
            }
            case 65: {
                return 65;
            }
        }
        throw new IllegalArgumentException("specified SignatureAlgorithm invalid: " + SignatureAlgorithm.getText(signatureAlgorithm));
    }

    public static TlsSecret hkdfExpandLabel(TlsSecret secret, short hashAlgorithm, String label, byte[] context, int length) throws IOException {
        int cryptoHashAlgorithm = TlsCryptoUtils.getHash(hashAlgorithm);
        return TlsCryptoUtils.hkdfExpandLabel(secret, cryptoHashAlgorithm, label, context, length);
    }

    public static TlsSecret hkdfExpandLabel(TlsSecret secret, int cryptoHashAlgorithm, String label, byte[] context, int length) throws IOException {
        int labelLength = label.length();
        if (labelLength < 1) {
            throw new TlsFatalAlert(80);
        }
        int contextLength = context.length;
        int expandedLabelLength = TLS13_PREFIX.length + labelLength;
        byte[] hkdfLabel = new byte[2 + (1 + expandedLabelLength) + (1 + contextLength)];
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, hkdfLabel, 0);
        TlsUtils.checkUint8(expandedLabelLength);
        TlsUtils.writeUint8(expandedLabelLength, hkdfLabel, 2);
        System.arraycopy(TLS13_PREFIX, 0, hkdfLabel, 3, TLS13_PREFIX.length);
        int labelPos = 2 + (1 + TLS13_PREFIX.length);
        for (int i = 0; i < labelLength; ++i) {
            char c = label.charAt(i);
            hkdfLabel[labelPos + i] = (byte)c;
        }
        TlsUtils.writeOpaque8(context, hkdfLabel, 2 + (1 + expandedLabelLength));
        return secret.hkdfExpand(cryptoHashAlgorithm, hkdfLabel, length);
    }
}

