/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.HeartbeatMessageType;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class HeartbeatMessage {
    protected short type;
    protected byte[] payload;
    protected byte[] padding;

    public static HeartbeatMessage create(TlsContext context, short type, byte[] payload) {
        return HeartbeatMessage.create(context, type, payload, 16);
    }

    public static HeartbeatMessage create(TlsContext context, short type, byte[] payload, int paddingLength) {
        byte[] padding = context.getNonceGenerator().generateNonce(paddingLength);
        return new HeartbeatMessage(type, payload, padding);
    }

    public HeartbeatMessage(short type, byte[] payload, byte[] padding) {
        if (!HeartbeatMessageType.isValid(type)) {
            throw new IllegalArgumentException("'type' is not a valid HeartbeatMessageType value");
        }
        if (null == payload || payload.length >= 65536) {
            throw new IllegalArgumentException("'payload' must have length < 2^16");
        }
        if (null == padding || padding.length < 16) {
            throw new IllegalArgumentException("'padding' must have length >= 16");
        }
        this.type = type;
        this.payload = payload;
        this.padding = padding;
    }

    public int getPaddingLength() {
        return this.padding.length;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public short getType() {
        return this.type;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.type, output);
        TlsUtils.checkUint16(this.payload.length);
        TlsUtils.writeUint16(this.payload.length, output);
        output.write(this.payload);
        output.write(this.padding);
    }

    public static HeartbeatMessage parse(InputStream input) throws IOException {
        short type = TlsUtils.readUint8(input);
        if (!HeartbeatMessageType.isValid(type)) {
            throw new TlsFatalAlert(47);
        }
        int payload_length = TlsUtils.readUint16(input);
        PayloadBuffer buf = new PayloadBuffer();
        Streams.pipeAll((InputStream)input, (OutputStream)buf);
        byte[] payload = buf.getPayload(payload_length);
        if (null == payload) {
            return null;
        }
        byte[] padding = buf.getPadding(payload_length);
        return new HeartbeatMessage(type, payload, padding);
    }

    static class PayloadBuffer
    extends ByteArrayOutputStream {
        PayloadBuffer() {
        }

        byte[] getPayload(int payloadLength) {
            int maxPayloadLength = this.count - 16;
            if (payloadLength > maxPayloadLength) {
                return null;
            }
            return Arrays.copyOf((byte[])this.buf, (int)payloadLength);
        }

        byte[] getPadding(int payloadLength) {
            return TlsUtils.copyOfRangeExact(this.buf, payloadLength, this.count);
        }
    }
}

