/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsHMAC;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsHMAC
implements TlsHMAC {
    private final Mac hmac;
    private final String algorithm;
    private final int internalBlockSize;

    public JceTlsHMAC(int cryptoHashAlgorithm, Mac hmac, String algorithm) {
        this.hmac = hmac;
        this.algorithm = algorithm;
        this.internalBlockSize = TlsCryptoUtils.getHashInternalSize(cryptoHashAlgorithm);
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        try {
            this.hmac.init(new SecretKeySpec(key, keyOff, keyLen, this.algorithm));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void update(byte[] input, int inOff, int length) {
        this.hmac.update(input, inOff, length);
    }

    public byte[] calculateMAC() {
        return this.hmac.doFinal();
    }

    public void calculateMAC(byte[] output, int outOff) {
        try {
            this.hmac.doFinal(output, outOff);
        }
        catch (ShortBufferException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getInternalBlockSize() {
        return this.internalBlockSize;
    }

    public int getMacLength() {
        return this.hmac.getMacLength();
    }

    public void reset() {
        this.hmac.reset();
    }
}

