/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.jsse.provider.EngineCreator;
import org.bouncycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BouncyCastleJsseProvider
extends Provider {
    public static final String PROVIDER_NAME = "BCJSSE";
    private static final double PROVIDER_VERSION = 1.0;
    private static final String PROVIDER_INFO = "Bouncy Castle JSSE Provider Version 1.0.0";
    private Map<String, BcJsseService> serviceMap = new HashMap<String, BcJsseService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final boolean isInFipsMode;
    private static final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();

    public BouncyCastleJsseProvider() {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.isInFipsMode = this.configure(false, new JcaTlsCryptoProvider());
    }

    public BouncyCastleJsseProvider(Provider provider) {
        this(false, provider);
    }

    public BouncyCastleJsseProvider(boolean bl, Provider provider) {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.isInFipsMode = this.configure(bl, new JcaTlsCryptoProvider().setProvider(provider));
    }

    public BouncyCastleJsseProvider(String string) {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        Object object;
        string = string.trim();
        boolean bl = false;
        String string2 = string;
        int n = string.indexOf(58);
        if (n >= 0) {
            object = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            bl = ((String)object).equalsIgnoreCase("fips");
            string2 = string3;
        }
        try {
            object = this.createCryptoProvider(string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalArgumentException("unable to set up TlsCrypto: " + generalSecurityException.getMessage(), generalSecurityException);
        }
        this.isInFipsMode = this.configure(bl, (JcaTlsCryptoProvider)object);
    }

    public BouncyCastleJsseProvider(boolean bl, JcaTlsCryptoProvider jcaTlsCryptoProvider) {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.isInFipsMode = this.configure(bl, jcaTlsCryptoProvider);
    }

    private JcaTlsCryptoProvider createCryptoProvider(String string) throws GeneralSecurityException {
        if (string.equalsIgnoreCase("default")) {
            return new JcaTlsCryptoProvider();
        }
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            return new JcaTlsCryptoProvider().setProvider(provider);
        }
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof JcaTlsCryptoProvider) {
                return (JcaTlsCryptoProvider)obj;
            }
            if (obj instanceof Provider) {
                return new JcaTlsCryptoProvider().setProvider((Provider)obj);
            }
            throw new IllegalArgumentException("unrecognized class: " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("unable to find Provider/TlsCrypto class: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("unable to create Provider/TlsCrypto class '" + string + "': " + instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("unable to create Provider/TlsCrypto class '" + string + "': " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    private boolean configure(final boolean bl, final JcaTlsCryptoProvider jcaTlsCryptoProvider) {
        this.addAlgorithmImplementation("KeyManagerFactory.X.509", "org.bouncycastle.jsse.provider.KeyManagerFactory", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvKeyManagerFactorySpi();
            }
        });
        this.addAlias("Alg.Alias.KeyManagerFactory.X509", "X.509");
        this.addAlias("Alg.Alias.KeyManagerFactory.PKIX", "X.509");
        this.addAlgorithmImplementation("TrustManagerFactory.PKIX", "org.bouncycastle.jsse.provider.TrustManagerFactory", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvTrustManagerFactorySpi(jcaTlsCryptoProvider.getPkixProvider());
            }
        });
        this.addAlias("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        this.addAlias("Alg.Alias.TrustManagerFactory.X509", "PKIX");
        this.addAlgorithmImplementation("SSLContext.TLS", "org.bouncycastle.jsse.provider.SSLContext.TLS", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvSSLContextSpi(bl, jcaTlsCryptoProvider, new String[]{"TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1", "org.bouncycastle.jsse.provider.SSLContext.TLSv1", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvSSLContextSpi(bl, jcaTlsCryptoProvider, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.1", "org.bouncycastle.jsse.provider.SSLContext.TLSv1_1", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvSSLContextSpi(bl, jcaTlsCryptoProvider, new String[]{"TLSv1.1", "TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.2", "org.bouncycastle.jsse.provider.SSLContext.TLSv1_2", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ProvSSLContextSpi(bl, jcaTlsCryptoProvider, new String[]{"TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.DEFAULT", "org.bouncycastle.jsse.provider.SSLContext.Default", new EngineCreator(){

            public Object createInstance(Object object) {
                try {
                    ProvSSLContextSpi provSSLContextSpi = new ProvSSLContextSpi(bl, jcaTlsCryptoProvider, new String[]{"TLSv1.2"});
                    provSSLContextSpi.engineInit(null, null, null);
                    return provSSLContextSpi;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    return null;
                }
            }
        });
        return bl;
    }

    void addAttribute(String string, String string2, String string3) {
        String string4 = string + " " + string2;
        if (this.containsKey(string4)) {
            throw new IllegalStateException("duplicate provider attribute key (" + string4 + ") found");
        }
        this.put(string4, string3);
    }

    void addAlgorithmImplementation(String string, String string2, EngineCreator engineCreator) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.addAttribute(string, "ImplementedIn", "Software");
        this.put(string, string2);
        this.creatorMap.put(string2, engineCreator);
    }

    void addAlias(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    @Override
    public final synchronized Provider.Service getService(String string, String string2) {
        String string3 = Strings.toUpperCase((String)string2);
        BcJsseService bcJsseService = this.serviceMap.get(string + "." + string3);
        if (bcJsseService == null) {
            String string4;
            String string5 = "Alg.Alias." + string + ".";
            String string6 = (String)this.get(string5 + string3);
            if (string6 == null) {
                string6 = string3;
            }
            if ((string4 = (String)this.get(string + "." + string6)) == null) {
                return null;
            }
            String string7 = string + "." + string3 + " ";
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Object object : this.keySet()) {
                String string8 = (String)object;
                if (string8.startsWith(string5) && this.get(object).equals(string2)) {
                    arrayList.add(string8.substring(string5.length()));
                }
                if (!string8.startsWith(string7)) continue;
                hashMap.put(string8.substring(string7.length()), (String)this.get(string8));
            }
            bcJsseService = new BcJsseService(this, string, string3, string4, arrayList, BouncyCastleJsseProvider.getAttributeMap(hashMap), this.creatorMap.get(string4));
            this.serviceMap.put(string + "." + string3, bcJsseService);
        }
        return bcJsseService;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> set = super.getServices();
        HashSet<Provider.Service> hashSet = new HashSet<Provider.Service>();
        for (Provider.Service service : set) {
            hashSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return hashSet;
    }

    private static Map<String, String> getAttributeMap(Map<String, String> map) {
        Map<String, String> map2 = attributeMaps.get(map);
        if (map2 != null) {
            return map2;
        }
        attributeMaps.put(map, map);
        return map;
    }

    public boolean isFipsMode() {
        return this.isInFipsMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BcJsseService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcJsseService(Provider provider, String string, String string2, String string3, List<String> list, Map<String, String> map, EngineCreator engineCreator) {
            super(provider, string, string2, string3, list, map);
            this.creator = engineCreator;
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            try {
                Object object2 = this.creator.createInstance(object);
                if (object2 == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return object2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + exception.getMessage(), exception);
            }
        }
    }
}

