/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.SSLParametersUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLParameters {
    static final boolean hasSslParameters;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private Object algorithmConstraints;
    private String endpointIdentificationAlgorithm;
    private boolean useCipherSuitesOrder;
    private List<BCSNIMatcher> sniMatchers;
    private List<BCSNIServerName> sniServerNames;

    ProvSSLParameters() {
    }

    private static <T> List<T> copyList(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = stringArray;
    }

    public void setProtocols(String[] stringArray) {
        this.protocols = stringArray;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public Object getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(Object object) {
        this.algorithmConstraints = object;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this.endpointIdentificationAlgorithm = string;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean bl) {
        this.useCipherSuitesOrder = bl;
    }

    public List<BCSNIServerName> getServerNames() {
        return ProvSSLParameters.copyList(this.sniServerNames);
    }

    public void setServerNames(List<BCSNIServerName> list) {
        throw new UnsupportedOperationException();
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return ProvSSLParameters.copyList(this.sniMatchers);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> collection) {
        throw new UnsupportedOperationException();
    }

    static ProvSSLParameters extractDefaultParameters(ProvSSLContextSpi provSSLContextSpi) {
        String[] stringArray;
        if (hasSslParameters) {
            return SSLParametersUtil.toProvSSLParameters(provSSLContextSpi.engineGetDefaultSSLParameters());
        }
        ProvSSLParameters provSSLParameters = new ProvSSLParameters();
        String[] stringArray2 = provSSLContextSpi.getDefaultCipherSuites();
        if (stringArray2 != null) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if ((stringArray = provSSLContextSpi.getDefaultProtocols()) != null) {
            provSSLParameters.setProtocols(stringArray);
        }
        provSSLParameters.setNeedClientAuth(false);
        provSSLParameters.setWantClientAuth(false);
        return provSSLParameters;
    }

    static {
        Class clazz = null;
        try {
            clazz = JsseUtils.loadClass(ProvSSLParameters.class, "javax.net.ssl.SSLParameters");
        }
        catch (Exception exception) {
            clazz = null;
        }
        hasSslParameters = clazz != null;
    }
}

