/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSTransport connect(TlsClient tlsClient, DatagramTransport datagramTransport) throws IOException {
        Object object;
        if (tlsClient == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 1;
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.client = tlsClient;
        clientHandshakeState.clientContext = new TlsClientContextImpl(tlsClient.getCrypto(), securityParameters);
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(tlsClient.shouldUseGMTUnixTime(), clientHandshakeState.clientContext);
        tlsClient.init(clientHandshakeState.clientContext);
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(datagramTransport, clientHandshakeState.clientContext, tlsClient, 22);
        TlsSession tlsSession = clientHandshakeState.client.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (object = tlsSession.exportSessionParameters()) != null) {
            clientHandshakeState.tlsSession = tlsSession;
            clientHandshakeState.sessionParameters = object;
        }
        try {
            object = this.clientHandshake(clientHandshakeState, dTLSRecordLayer);
            return object;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer, short s) {
        dTLSRecordLayer.fail(s);
        this.invalidateSession(clientHandshakeState);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        byte[] byArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParameters();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(clientHandshakeState.clientContext, dTLSRecordLayer);
        byte[] byArray2 = this.generateClientHello(clientHandshakeState, clientHandshakeState.client);
        dTLSRecordLayer.setWriteVersion(ProtocolVersion.DTLSv10);
        dTLSReliableHandshake.sendMessage((short)1, byArray2);
        DTLSReliableHandshake.Message message = dTLSReliableHandshake.receiveMessage();
        while (message.getType() == 3) {
            object5 = dTLSRecordLayer.getReadVersion();
            if (!((ProtocolVersion)object5).isEqualOrEarlierVersionOf((ProtocolVersion)(object4 = clientHandshakeState.clientContext.getClientVersion()))) {
                throw new TlsFatalAlert(47);
            }
            dTLSRecordLayer.setReadVersion(null);
            object3 = this.processHelloVerifyRequest(clientHandshakeState, message.getBody());
            object2 = DTLSClientProtocol.patchClientHelloWithCookie(byArray2, object3);
            dTLSReliableHandshake.resetHandshakeMessagesDigest();
            dTLSReliableHandshake.sendMessage((short)1, (byte[])object2);
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        object5 = dTLSRecordLayer.getReadVersion();
        this.reportServerVersion(clientHandshakeState, (ProtocolVersion)object5);
        dTLSRecordLayer.setWriteVersion((ProtocolVersion)object5);
        this.processServerHello(clientHandshakeState, message.getBody());
        dTLSReliableHandshake.notifyHelloComplete();
        DTLSClientProtocol.applyMaxFragmentLengthExtension(dTLSRecordLayer, securityParameters.getMaxFragmentLength());
        if (clientHandshakeState.resumedSession) {
            securityParameters.masterSecret = clientHandshakeState.clientContext.getCrypto().adoptSecret(clientHandshakeState.sessionParameters.getMasterSecret());
            dTLSRecordLayer.initPendingEpoch(clientHandshakeState.client.getCipher());
            object5 = this.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, true);
            this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), (byte[])object5);
            object4 = this.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, false);
            dTLSReliableHandshake.sendMessage((short)20, (byte[])object4);
            dTLSReliableHandshake.finish();
            securityParameters.tlsUnique = (byte[])object5;
            clientHandshakeState.clientContext.setSession(clientHandshakeState.tlsSession);
            clientHandshakeState.client.notifyHandshakeComplete();
            return new DTLSTransport(dTLSRecordLayer);
        }
        this.invalidateSession(clientHandshakeState);
        clientHandshakeState.tlsSession = TlsUtils.importSession(clientHandshakeState.selectedSessionID, null);
        clientHandshakeState.sessionParameters = null;
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processServerSupplementalData(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.client.processServerSupplementalData(null);
        }
        clientHandshakeState.keyExchange = clientHandshakeState.client.getKeyExchange();
        clientHandshakeState.keyExchange.init(clientHandshakeState.clientContext);
        object5 = null;
        if (message.getType() == 11) {
            object5 = this.processServerCertificate(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.authentication = null;
        }
        if (object5 == null || ((Certificate)object5).isEmpty()) {
            clientHandshakeState.allowCertificateStatus = false;
        }
        if (message.getType() == 22) {
            this.processCertificateStatus(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (clientHandshakeState.authentication == null) {
            clientHandshakeState.keyExchange.skipServerCredentials();
        } else {
            TlsUtils.processServerCertificate((Certificate)object5, clientHandshakeState.certificateStatus, clientHandshakeState.keyExchange, clientHandshakeState.authentication, clientHandshakeState.clientExtensions, clientHandshakeState.serverExtensions);
        }
        if (message.getType() == 12) {
            this.processServerKeyExchange(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.keyExchange.skipServerKeyExchange();
        }
        if (message.getType() == 13) {
            this.processCertificateRequest(clientHandshakeState, message.getBody());
            TlsUtils.trackHashAlgorithms(dTLSReliableHandshake.getHandshakeHash(), clientHandshakeState.certificateRequest.getSupportedSignatureAlgorithms());
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() == 14) {
            if (message.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        object4 = clientHandshakeState.client.getClientSupplementalData();
        if (object4 != null) {
            object3 = DTLSClientProtocol.generateSupplementalData((Vector)object4);
            dTLSReliableHandshake.sendMessage((short)23, (byte[])object3);
        }
        object3 = null;
        if (clientHandshakeState.certificateRequest != null) {
            clientHandshakeState.clientCredentials = TlsProtocol.validateCredentials(clientHandshakeState.authentication.getClientCredentials(clientHandshakeState.certificateRequest));
            if (clientHandshakeState.clientCredentials != null) {
                object3 = clientHandshakeState.clientCredentials.getCertificate();
            }
            if (object3 == null) {
                object3 = Certificate.EMPTY_CHAIN;
            }
            object2 = DTLSClientProtocol.generateCertificate((Certificate)object3);
            dTLSReliableHandshake.sendMessage((short)11, (byte[])object2);
        }
        object2 = null;
        TlsStreamSigner tlsStreamSigner = null;
        if (clientHandshakeState.clientCredentials != null) {
            clientHandshakeState.keyExchange.processClientCredentials(clientHandshakeState.clientCredentials);
            if (clientHandshakeState.clientCredentials instanceof TlsCredentialedSigner) {
                object2 = (TlsCredentialedSigner)clientHandshakeState.clientCredentials;
                tlsStreamSigner = object2.getStreamSigner();
            }
        } else {
            clientHandshakeState.keyExchange.skipClientCredentials();
        }
        boolean bl = tlsStreamSigner != null;
        TlsUtils.sealHandshakeHash(clientHandshakeState.clientContext, dTLSReliableHandshake.getHandshakeHash(), bl);
        byte[] byArray3 = this.generateClientKeyExchange(clientHandshakeState);
        dTLSReliableHandshake.sendMessage((short)16, byArray3);
        TlsHandshakeHash tlsHandshakeHash = dTLSReliableHandshake.prepareToFinish();
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(tlsHandshakeHash);
        TlsProtocol.establishMasterSecret(clientHandshakeState.clientContext, clientHandshakeState.keyExchange);
        dTLSRecordLayer.initPendingEpoch(clientHandshakeState.client.getCipher());
        if (object2 != null) {
            object = TlsUtils.generateCertificateVerify(clientHandshakeState.clientContext, (TlsCredentialedSigner)object2, tlsStreamSigner, tlsHandshakeHash);
            byArray = this.generateCertificateVerify(clientHandshakeState, (DigitallySigned)object);
            dTLSReliableHandshake.sendMessage((short)15, byArray);
        }
        object = this.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, false);
        dTLSReliableHandshake.sendMessage((short)20, (byte[])object);
        if (clientHandshakeState.expectSessionTicket) {
            message = dTLSReliableHandshake.receiveMessage();
            if (message.getType() == 4) {
                this.processNewSessionTicket(clientHandshakeState, message.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        byArray = this.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, true);
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), byArray);
        dTLSReliableHandshake.finish();
        clientHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setLocalCertificate((Certificate)object3).setMasterSecret(clientHandshakeState.clientContext.getCrypto().adoptSecret(securityParameters.getMasterSecret())).setNegotiatedVersion(clientHandshakeState.clientContext.getServerVersion()).setPeerCertificate((Certificate)object5).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(clientHandshakeState.serverExtensions).build();
        clientHandshakeState.tlsSession = TlsUtils.importSession(clientHandshakeState.tlsSession.getSessionID(), clientHandshakeState.sessionParameters);
        securityParameters.tlsUnique = (byte[])object;
        clientHandshakeState.clientContext.setSession(clientHandshakeState.tlsSession);
        clientHandshakeState.client.notifyHandshakeComplete();
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState clientHandshakeState, DigitallySigned digitallySigned) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        digitallySigned.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState clientHandshakeState, TlsClient tlsClient) throws IOException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = tlsClient.getClientVersion();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        tlsClientContextImpl.setClientVersion(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParameters();
        byteArrayOutputStream.write(securityParameters.getClientRandom());
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (clientHandshakeState.tlsSession != null && ((byArray = clientHandshakeState.tlsSession.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        TlsUtils.writeOpaque8(byArray, byteArrayOutputStream);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        boolean bl2 = tlsClient.isFallback();
        clientHandshakeState.offeredCipherSuites = tlsClient.getCipherSuites();
        clientHandshakeState.clientExtensions = tlsClient.getClientExtensions();
        byte[] byArray2 = TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, TlsProtocol.EXT_RenegotiationInfo);
        boolean bl3 = null == byArray2;
        boolean bl4 = bl = !Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)255);
        if (bl3 && bl) {
            clientHandshakeState.offeredCipherSuites = Arrays.append((int[])clientHandshakeState.offeredCipherSuites, (int)255);
        }
        if (bl2 && !Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)22016)) {
            clientHandshakeState.offeredCipherSuites = Arrays.append((int[])clientHandshakeState.offeredCipherSuites, (int)22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(clientHandshakeState.offeredCipherSuites, byteArrayOutputStream);
        clientHandshakeState.offeredCompressionMethods = new short[]{0};
        TlsUtils.writeUint8ArrayWithUint8Length(clientHandshakeState.offeredCompressionMethods, byteArrayOutputStream);
        if (clientHandshakeState.clientExtensions != null) {
            TlsProtocol.writeExtensions(byteArrayOutputStream, clientHandshakeState.clientExtensions);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState clientHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHandshakeState.keyExchange.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState clientHandshakeState) {
        if (clientHandshakeState.sessionParameters != null) {
            clientHandshakeState.sessionParameters.clear();
            clientHandshakeState.sessionParameters = null;
        }
        if (clientHandshakeState.tlsSession != null) {
            clientHandshakeState.tlsSession.invalidate();
            clientHandshakeState.tlsSession = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (clientHandshakeState.authentication == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateRequest = CertificateRequest.parse(clientHandshakeState.clientContext, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.keyExchange.validateCertificateRequest(clientHandshakeState.certificateRequest);
    }

    protected void processCertificateStatus(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (!clientHandshakeState.allowCertificateStatus) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateStatus = CertificateStatus.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(clientHandshakeState.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        if (!ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) && byArray2.length > 32) {
            throw new TlsFatalAlert(47);
        }
        return byArray2;
    }

    protected void processNewSessionTicket(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected Certificate processServerCertificate(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse(clientHandshakeState.clientContext, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.authentication = clientHandshakeState.client.getAuthentication();
        if (clientHandshakeState.authentication == null) {
            throw new TlsFatalAlert(80);
        }
        return certificate;
    }

    protected void processServerHello(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        Serializable serializable;
        Object object;
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParameters();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        this.reportServerVersion(clientHandshakeState, protocolVersion);
        securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        clientHandshakeState.selectedSessionID = TlsUtils.readOpaque8(byteArrayInputStream);
        if (clientHandshakeState.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        clientHandshakeState.client.notifySessionID(clientHandshakeState.selectedSessionID);
        clientHandshakeState.resumedSession = clientHandshakeState.selectedSessionID.length > 0 && clientHandshakeState.tlsSession != null && Arrays.areEqual((byte[])clientHandshakeState.selectedSessionID, (byte[])clientHandshakeState.tlsSession.getSessionID());
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (!Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)n) || n == 0 || CipherSuite.isSCSV(n) || !TlsUtils.isValidCipherSuiteForVersion(n, clientHandshakeState.clientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(n, (short)47);
        clientHandshakeState.client.notifySelectedCipherSuite(n);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        if (!Arrays.contains((short[])clientHandshakeState.offeredCompressionMethods, (short)s)) {
            throw new TlsFatalAlert(47);
        }
        clientHandshakeState.client.notifySelectedCompressionMethod(s);
        clientHandshakeState.serverExtensions = TlsProtocol.readExtensions(byteArrayInputStream);
        if (clientHandshakeState.serverExtensions != null) {
            object = clientHandshakeState.serverExtensions.keys();
            while (object.hasMoreElements()) {
                serializable = (Integer)object.nextElement();
                if (serializable.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!clientHandshakeState.resumedSession) continue;
            }
        }
        if ((object = (Object)TlsUtils.getExtensionData(clientHandshakeState.serverExtensions, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            clientHandshakeState.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, (byte[])TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        clientHandshakeState.client.notifySecureRenegotiation(clientHandshakeState.secure_renegotiation);
        object = clientHandshakeState.clientExtensions;
        serializable = clientHandshakeState.serverExtensions;
        if (clientHandshakeState.resumedSession) {
            if (n != clientHandshakeState.sessionParameters.getCipherSuite() || s != clientHandshakeState.sessionParameters.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = clientHandshakeState.sessionParameters.readServerExtensions();
        }
        securityParameters.cipherSuite = n;
        securityParameters.compressionAlgorithm = s;
        if (serializable != null) {
            boolean bl = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl;
            securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serializable);
            securityParameters.maxFragmentLength = DTLSClientProtocol.evaluateMaxFragmentLengthExtension(clientHandshakeState.resumedSession, (Hashtable)object, (Hashtable)serializable, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            clientHandshakeState.allowCertificateStatus = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl2 = clientHandshakeState.expectSessionTicket = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            clientHandshakeState.client.processServerExtensions((Hashtable)serializable);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(clientHandshakeState.clientContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void processServerKeyExchange(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.keyExchange.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        clientHandshakeState.client.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState clientHandshakeState, ProtocolVersion protocolVersion) throws IOException {
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        ProtocolVersion protocolVersion2 = tlsClientContextImpl.getServerVersion();
        if (null == protocolVersion2) {
            tlsClientContextImpl.setServerVersion(protocolVersion);
            clientHandshakeState.client.notifyServerVersion(protocolVersion);
        } else if (!protocolVersion2.equals(protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected static byte[] patchClientHelloWithCookie(byte[] byArray, byte[] byArray2) throws IOException {
        int n = 34;
        short s = TlsUtils.readUint8(byArray, n);
        int n2 = n + 1 + s;
        int n3 = n2 + 1;
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        TlsUtils.checkUint8(byArray2.length);
        TlsUtils.writeUint8(byArray2.length, byArray3, n2);
        System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
        System.arraycopy(byArray, n3, byArray3, n3 + byArray2.length, byArray.length - n3);
        return byArray3;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        TlsClientContextImpl clientContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        short[] offeredCompressionMethods = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        byte[] selectedSessionID = null;
        boolean resumedSession = false;
        boolean secure_renegotiation = false;
        boolean allowCertificateStatus = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateStatus certificateStatus = null;
        CertificateRequest certificateRequest = null;
        TlsCredentials clientCredentials = null;

        protected ClientHandshakeState() {
        }
    }
}

