/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsRSAUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;

public class TlsRSAKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    public TlsRSAKeyExchange(Vector vector) {
        super(1, vector);
    }

    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedDecryptor)tlsCredentials;
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(certificate);
        this.serverCertificate = certificate.getCertificateAt(0).useInRole(0, this.keyExchange);
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, outputStream);
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), byArray);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tlsSecret = this.preMasterSecret;
        this.preMasterSecret = null;
        return tlsSecret;
    }
}

