/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.SSLSocketUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ProvSSLSocketBase
extends SSLSocket
implements BCSSLSocket {
    protected static final boolean provJdkTlsTrustNameService = PropertyUtils.getBooleanSystemProperty("jdk.tls.trustNameService", false);
    protected final Closeable socketCloser = new Closeable(){

        public void close() throws IOException {
            ProvSSLSocketBase.this.closeSocket();
        }
    };
    protected final Map<HandshakeCompletedListener, AccessControlContext> listeners = Collections.synchronizedMap(new HashMap(4));

    protected ProvSSLSocketBase() {
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        this.listeners.put(handshakeCompletedListener, AccessController.getContext());
    }

    protected void closeSocket() throws IOException {
        super.close();
    }

    @Override
    public SocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return false;
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        if (null == this.listeners.remove(handshakeCompletedListener)) {
            throw new IllegalArgumentException("'listener' is not registered");
        }
    }

    @Override
    public void sendUrgentData(int n) throws IOException {
        throw new UnsupportedOperationException("Urgent data not supported in TLS");
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        if (bl) {
            throw new UnsupportedOperationException("Urgent data not supported in TLS");
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("shutdownInput() not supported in TLS");
    }

    @Override
    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("shutdownOutput() not supported in TLS");
    }

    protected void implBind(InetAddress inetAddress, int n) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.bind(inetSocketAddress);
    }

    protected void implConnect(InetAddress inetAddress, int n) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    protected void implConnect(String string, int n) throws IOException, UnknownHostException {
        InetSocketAddress inetSocketAddress = null == string ? new InetSocketAddress(InetAddress.getByName(null), n) : new InetSocketAddress(string, n);
        this.connect(inetSocketAddress, 0);
    }

    protected void notifyHandshakeCompletedListeners(SSLSession sSLSession) {
        final Collection<Map.Entry<HandshakeCompletedListener, AccessControlContext>> collection = this.getHandshakeCompletedEntries();
        if (null == collection) {
            return;
        }
        final HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, sSLSession);
        Runnable runnable = new Runnable(){

            public void run() {
                for (Map.Entry entry : collection) {
                    final HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)entry.getKey();
                    AccessControlContext accessControlContext = (AccessControlContext)entry.getValue();
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            handshakeCompletedListener.handshakeCompleted(handshakeCompletedEvent);
                            return null;
                        }
                    }, accessControlContext);
                }
            }
        };
        SSLSocketUtil.handshakeCompleted(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Map.Entry<HandshakeCompletedListener, AccessControlContext>> getHandshakeCompletedEntries() {
        Map<HandshakeCompletedListener, AccessControlContext> map = this.listeners;
        synchronized (map) {
            return this.listeners.isEmpty() ? null : new ArrayList<Map.Entry<HandshakeCompletedListener, AccessControlContext>>(this.listeners.entrySet());
        }
    }
}

