/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLEngine.class.getName());
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected boolean useClientModeSet = false;
    protected boolean closedEarly = false;
    protected boolean initialHandshakeBegun = false;
    protected boolean returnedFinished = false;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ContextData contextData) {
        this(contextData, null, -1);
    }

    protected ProvSSLEngine(ContextData contextData, String string, int n) {
        super(string, n);
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (!this.useClientModeSet) {
            throw new IllegalStateException("Client/Server mode must be set before the handshake can begin");
        }
        if (this.closedEarly) {
            throw new SSLException("Connection is already closed");
        }
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol tlsClientProtocol = new TlsClientProtocol();
                this.protocol = tlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this, this.sslParameters);
                this.protocolPeer = provTlsClient;
                tlsClientProtocol.connect(provTlsClient);
            } else {
                TlsServerProtocol tlsServerProtocol = new TlsServerProtocol();
                this.protocol = tlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this, this.sslParameters);
                this.protocolPeer = provTlsServer;
                tlsServerProtocol.accept(provTlsServer);
            }
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    @Override
    public BCX509Key chooseClientKey(String[] stringArray, Principal[] principalArray) {
        return this.getContextData().getX509KeyManager().chooseEngineClientKeyBC(stringArray, JsseUtils.clone(principalArray), this);
    }

    @Override
    public BCX509Key chooseServerKey(String[] stringArray, Principal[] principalArray) {
        return this.getContextData().getX509KeyManager().chooseEngineServerKeyBC(stringArray, JsseUtils.clone(principalArray), this);
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.closeInput();
                }
                catch (IOException iOException) {
                    throw new SSLException(iOException);
                }
            }
        }
    }

    @Override
    public synchronized void closeOutbound() {
        if (!this.closedEarly) {
            if (null == this.protocol) {
                this.closedEarly = true;
            } else {
                try {
                    this.protocol.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Failed to close outbound", iOException);
                }
            }
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return null == this.connection ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLEngine> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getEngineAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public BCExtendedSSLSession getBCSession() {
        return this.getSessionImpl();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return null == this.handshakeSession ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.protocol != null) {
            if (this.protocol.getAvailableOutputBytes() > 0 || this.deferredException != null) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.protocol.isHandshaking()) {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public SSLSession getSession() {
        return this.getSessionImpl().getExportSSLSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.contextData.getContext().getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.closedEarly || null != this.protocol && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLEngine> bCApplicationProtocolSelector) {
        this.sslParameters.setEngineAPSelector(bCApplicationProtocolSelector);
    }

    @Override
    public synchronized void setBCSessionToResume(BCExtendedSSLSession bCExtendedSSLSession) {
        if (null == bCExtendedSSLSession) {
            throw new NullPointerException("'session' cannot be null");
        }
        if (!(bCExtendedSSLSession instanceof ProvSSLSession)) {
            throw new IllegalArgumentException("Session-to-resume must be a session returned from 'getBCSession'");
        }
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Session-to-resume cannot be set after the handshake has begun");
        }
        this.sslParameters.setSessionToResume((ProvSSLSession)bCExtendedSSLSession);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setCipherSuites(stringArray);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setProtocols(stringArray);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters bCSSLParameters) {
        SSLParametersUtil.setParameters(this.sslParameters, bCSSLParameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sSLParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Client/Server mode cannot be changed after the handshake has begun");
        }
        if (this.useClientMode != bl) {
            this.contextData.getContext().updateDefaultSSLParameters(this.sslParameters, bl);
            this.useClientMode = bl;
        }
        this.useClientModeSet = true;
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if (this.isInboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, handshakeStatus, 0, 0);
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        switch (handshakeStatus) {
            case NEED_UNWRAP: 
            case NOT_HANDSHAKING: {
                break;
            }
            default: {
                return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
            }
        }
        int n3 = 0;
        try {
            RecordPreview recordPreview = this.getRecordPreview(byteBuffer);
            if (recordPreview == null || byteBuffer.remaining() < recordPreview.getRecordSize()) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, handshakeStatus, 0, 0);
            }
            if (this.hasInsufficientSpace(byteBufferArray, n, n2, recordPreview.getContentLimit())) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
            }
            n3 = recordPreview.getRecordSize();
            byte[] byArray = new byte[n3];
            byteBuffer.get(byArray);
            this.protocol.offerInput(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                throw new SSLException(iOException);
            }
            this.deferredException = new SSLException(iOException);
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n3, 0);
        }
        int n4 = this.protocol.getAvailableInputBytes();
        int n5 = 0;
        int n6 = 0;
        while (n4 > 0) {
            ByteBuffer byteBuffer2 = byteBufferArray[n + n6];
            int n7 = Math.min(byteBuffer2.remaining(), n4);
            if (n7 > 0) {
                int n8 = this.protocol.readInput(byteBuffer2, n7);
                assert (n8 == n7);
                n5 += n7;
                n4 -= n7;
            }
            ++n6;
        }
        SSLEngineResult.HandshakeStatus handshakeStatus2 = this.getHandshakeStatus();
        if (handshakeStatus2 == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && !this.returnedFinished && this.protocolPeer.isHandshakeComplete()) {
            this.returnedFinished = true;
            handshakeStatus2 = SSLEngineResult.HandshakeStatus.FINISHED;
        }
        return new SSLEngineResult(this.getStatus(), handshakeStatus2, n3, n5);
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        if (this.deferredException != null) {
            SSLException sSLException = this.deferredException;
            this.deferredException = null;
            throw sSLException;
        }
        if (this.closedEarly) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        int n3 = 0;
        int n4 = this.protocol.getAvailableOutputBytes();
        if (n4 > 0) {
            int n5 = byteBuffer.remaining();
            if (n5 >= n4) {
                n3 = n4;
            } else {
                n3 = this.protocol.previewOutputRecord();
                assert (n3 > 0);
                if (n5 < n3) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
                }
            }
            int n6 = this.protocol.readOutput(byteBuffer, n3);
            assert (n6 == n3);
            if (n3 < n4) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n3);
            }
        } else if (this.protocol.isConnected()) {
            try {
                int n7 = 0;
                int n8 = this.getTotalRemaining(byteBufferArray, n, n2, this.protocol.getApplicationDataLimit());
                if (n8 > 0) {
                    int n9;
                    RecordPreview recordPreview = this.protocol.previewOutputRecord(n8);
                    int n10 = recordPreview.getContentLimit();
                    int n11 = recordPreview.getRecordSize();
                    if (byteBuffer.remaining() < n11) {
                        return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
                    }
                    byte[] byArray = new byte[n10];
                    for (n9 = 0; n9 < n2 && n7 < n10; ++n9) {
                        ByteBuffer byteBuffer2 = byteBufferArray[n + n9];
                        int n12 = Math.min(byteBuffer2.remaining(), n10 - n7);
                        if (n12 <= 0) continue;
                        byteBuffer2.get(byArray, n7, n12);
                        n7 += n12;
                    }
                    this.protocol.writeApplicationData(byArray, 0, n7);
                    n3 = this.protocol.getAvailableOutputBytes();
                    assert (n3 <= n11);
                    n9 = this.protocol.readOutput(byteBuffer, n3);
                    assert (n9 == n3);
                }
                return new SSLEngineResult(this.getStatus(), SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, n7, n3);
            }
            catch (IOException iOException) {
                throw new SSLException(iOException);
            }
        }
        if (this.protocol.isHandshaking()) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, n3);
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        if (!this.returnedFinished && this.protocolPeer.isHandshakeComplete()) {
            this.returnedFinished = true;
            handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
        }
        return new SSLEngineResult(this.getStatus(), handshakeStatus, 0, n3);
    }

    @Override
    public String getPeerHost() {
        return super.getPeerHost();
    }

    @Override
    public String getPeerHostSNI() {
        return super.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return super.getPeerPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        if (null != this.handshakeSession) {
            if (!this.handshakeSession.isValid()) {
                provSSLConnection.getSession().invalidate();
            }
            this.handshakeSession.getJsseSecurityParameters().clear();
        }
        this.handshakeSession = null;
        this.connection = provSSLConnection;
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionContext provSSLSessionContext, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, ProvSSLSession provSSLSession) {
        String string = this.getPeerHost();
        int n = this.getPeerPort();
        this.handshakeSession = null != provSSLSession ? new ProvSSLSessionResumed(provSSLSessionContext, string, n, securityParameters, jsseSecurityParameters, provSSLSession.getTlsSession(), provSSLSession.getJsseSessionParameters()) : new ProvSSLSessionHandshake(provSSLSessionContext, string, n, securityParameters, jsseSecurityParameters);
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> list) {
        return this.sslParameters.getEngineAPSelector().select(this, list);
    }

    ProvSSLSession getSessionImpl() {
        return null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    private RecordPreview getRecordPreview(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() < 5) {
            return null;
        }
        byte[] byArray = new byte[5];
        int n = byteBuffer.position();
        byteBuffer.get(byArray);
        byteBuffer.position(n);
        return this.protocol.previewInputRecord(byArray);
    }

    private SSLEngineResult.Status getStatus() {
        return this.protocol.isClosed() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    private int getTotalRemaining(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[n + i];
            int n5 = byteBuffer.remaining();
            if (n5 >= n3 - n4) {
                return n3;
            }
            n4 += n5;
        }
        return n4;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        return this.getTotalRemaining(byteBufferArray, n, n2, n3) < n3;
    }
}

