/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsClientProtocol;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.ProvTlsServerProtocol;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLSocketWrap
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLSocketWrap.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ContextData contextData;
    protected final Socket wrapSocket;
    protected final InputStream consumed;
    protected final boolean autoClose;
    protected final ProvSSLParameters sslParameters;
    protected String peerHost = null;
    protected String peerHostSNI = null;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;

    private static Socket checkSocket(Socket socket) throws SocketException {
        if (socket == null) {
            throw new NullPointerException("'s' cannot be null");
        }
        if (!socket.isConnected()) {
            throw new SocketException("'s' is not a connected socket");
        }
        return socket;
    }

    protected ProvSSLSocketWrap(ContextData contextData, Socket socket, InputStream inputStream, boolean bl) throws IOException {
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(socket);
        this.consumed = inputStream;
        this.autoClose = bl;
        this.useClientMode = false;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.notifyConnected();
    }

    protected ProvSSLSocketWrap(ContextData contextData, Socket socket, String string, int n, boolean bl) throws IOException {
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(socket);
        this.consumed = null;
        this.peerHost = string;
        this.autoClose = bl;
        this.useClientMode = true;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.notifyConnected();
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        throw new SocketException("Wrapped socket should already be bound");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted((X509Certificate[])x509CertificateArray.clone(), string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted((X509Certificate[])x509CertificateArray.clone(), string, this);
        }
        catch (CertificateException certificateException) {
            throw new TlsFatalAlert(46, (Throwable)certificateException);
        }
    }

    @Override
    public BCX509Key chooseClientKey(String[] stringArray, Principal[] principalArray) {
        return this.getContextData().getX509KeyManager().chooseClientKeyBC(stringArray, JsseUtils.clone(principalArray), this);
    }

    @Override
    public BCX509Key chooseServerKey(String[] stringArray, Principal[] principalArray) {
        return this.getContextData().getX509KeyManager().chooseServerKeyBC(stringArray, JsseUtils.clone(principalArray), this);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    @Override
    protected void closeSocket() throws IOException {
        if (this.autoClose) {
            this.wrapSocket.close();
        } else if (this.protocol != null) {
            // empty if block
        }
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        throw new SocketException("Wrapped socket should already be connected");
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return null == this.connection ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLSocket> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getSocketAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public BCExtendedSSLSession getBCSession() {
        return this.getSessionImpl();
    }

    @Override
    public SocketChannel getChannel() {
        return this.wrapSocket.getChannel();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Failed to establish connection", exception);
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return null == this.handshakeSession ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.wrapSocket.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.wrapSocket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.wrapSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.wrapSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.wrapSocket.getLocalSocketAddress();
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public int getPort() {
        return this.wrapSocket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.wrapSocket.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.wrapSocket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.wrapSocket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.wrapSocket.getSendBufferSize();
    }

    @Override
    public SSLSession getSession() {
        return this.getSessionImpl().getExportSSLSession();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.wrapSocket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.wrapSocket.getSoTimeout();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.contextData.getContext().getSupportedProtocols();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapSocket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.wrapSocket.getTrafficClass();
    }

    @Override
    public int getTransportID() {
        return System.identityHashCode(this);
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public boolean isBound() {
        return this.wrapSocket.isBound();
    }

    @Override
    public boolean isConnected() {
        return this.wrapSocket.isConnected();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.protocol != null && this.protocol.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.wrapSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.wrapSocket.isOutputShutdown();
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLSocket> bCApplicationProtocolSelector) {
        this.sslParameters.setSocketAPSelector(bCApplicationProtocolSelector);
    }

    @Override
    public synchronized void setBCSessionToResume(BCExtendedSSLSession bCExtendedSSLSession) {
        if (null == bCExtendedSSLSession) {
            throw new NullPointerException("'session' cannot be null");
        }
        if (!(bCExtendedSSLSession instanceof ProvSSLSession)) {
            throw new IllegalArgumentException("Session-to-resume must be a session returned from 'getBCSession'");
        }
        if (null != this.protocol) {
            throw new IllegalArgumentException("Session-to-resume cannot be set after the handshake has begun");
        }
        this.sslParameters.setSessionToResume((ProvSSLSession)bCExtendedSSLSession);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setCipherSuites(stringArray);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setProtocols(stringArray);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    @Override
    public synchronized void setHost(String string) {
        this.peerHost = string;
        this.peerHostSNI = string;
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        this.wrapSocket.setKeepAlive(bl);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters bCSSLParameters) {
        SSLParametersUtil.setParameters(this.sslParameters, bCSSLParameters);
    }

    @Override
    public void setPerformancePreferences(int n, int n2, int n3) {
        this.wrapSocket.setPerformancePreferences(n, n2, n3);
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        this.wrapSocket.setReceiveBufferSize(n);
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.wrapSocket.setReuseAddress(bl);
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        this.wrapSocket.setSendBufferSize(n);
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.wrapSocket.setSoLinger(bl, n);
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        this.wrapSocket.setSoTimeout(n);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sSLParameters);
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.wrapSocket.setTcpNoDelay(bl);
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        this.wrapSocket.setTrafficClass(n);
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        if (null != this.protocol) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != bl) {
            this.contextData.getContext().updateDefaultSSLParameters(this.sslParameters, bl);
            this.useClientMode = bl;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.wrapSocket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.wrapSocket.shutdownOutput();
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean bl) throws IOException {
        if (this.protocol == null) {
            InputStream inputStream = this.wrapSocket.getInputStream();
            if (this.consumed != null) {
                inputStream = new SequenceInputStream(this.consumed, inputStream);
            }
            OutputStream outputStream = this.wrapSocket.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol provTlsClientProtocol = new ProvTlsClientProtocol(inputStream, outputStream, this.socketCloser);
                provTlsClientProtocol.setResumableHandshake(bl);
                this.protocol = provTlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this, this.sslParameters);
                this.protocolPeer = provTlsClient;
                provTlsClientProtocol.connect(provTlsClient);
            } else {
                ProvTlsServerProtocol provTlsServerProtocol = new ProvTlsServerProtocol(inputStream, outputStream, this.socketCloser);
                provTlsServerProtocol.setResumableHandshake(bl);
                this.protocol = provTlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this, this.sslParameters);
                this.protocolPeer = provTlsServer;
                provTlsServerProtocol.accept(provTlsServer);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(bl);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    @Override
    public String toString() {
        return this.wrapSocket.toString();
    }

    @Override
    public synchronized String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public synchronized String getPeerHostSNI() {
        return this.peerHostSNI;
    }

    @Override
    public int getPeerPort() {
        return this.getPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        if (null != this.handshakeSession) {
            if (!this.handshakeSession.isValid()) {
                provSSLConnection.getSession().invalidate();
            }
            this.handshakeSession.getJsseSecurityParameters().clear();
        }
        this.handshakeSession = null;
        this.connection = provSSLConnection;
        this.notifyHandshakeCompletedListeners(provSSLConnection.getSession().exportSSLSession);
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionContext provSSLSessionContext, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, ProvSSLSession provSSLSession) {
        String string = this.getPeerHost();
        int n = this.getPeerPort();
        this.handshakeSession = null != provSSLSession ? new ProvSSLSessionResumed(provSSLSessionContext, string, n, securityParameters, jsseSecurityParameters, provSSLSession.getTlsSession(), provSSLSession.getJsseSessionParameters()) : new ProvSSLSessionHandshake(provSSLSessionContext, string, n, securityParameters, jsseSecurityParameters);
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> list) {
        return this.sslParameters.getSocketAPSelector().select(this, list);
    }

    synchronized ProvSSLSession getSessionImpl() {
        this.getConnection();
        return null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    synchronized void handshakeIfNecessary(boolean bl) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(bl);
        }
    }

    synchronized void notifyConnected() {
        if (JsseUtils.isNameSpecified(this.peerHost)) {
            this.peerHostSNI = this.peerHost;
            return;
        }
        InetAddress inetAddress = this.getInetAddress();
        if (null == inetAddress) {
            return;
        }
        if (this.useClientMode && provAssumeOriginalHostName) {
            String string;
            this.peerHost = string = inetAddress.getHostName();
            this.peerHostSNI = string;
            return;
        }
        this.peerHost = this.useClientMode && provJdkTlsTrustNameService ? inetAddress.getHostName() : inetAddress.getHostAddress();
        this.peerHostSNI = null;
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                return ProvSSLSocketWrap.this.protocol == null ? 0 : ProvSSLSocketWrap.this.protocol.applicationDataAvailable();
            }
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        public int read() throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            byte[] byArray = new byte[1];
            int n = ProvSSLSocketWrap.this.protocol.readApplicationData(byArray, 0, 1);
            return n < 1 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 < 1) {
                return 0;
            }
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            return ProvSSLSocketWrap.this.protocol.readApplicationData(byArray, n, n2);
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                ProvSSLSocketWrap.this.handshakeIfNecessary(true);
                ProvSSLSocketWrap.this.protocol.writeApplicationData(byArray, n, n2);
            }
        }
    }
}

