/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.GCMUtil;
import org.bouncycastle.util.Arrays;

public class JceAEADCipherImpl
implements TlsAEADCipherImpl {
    private static final boolean canDoAEAD = JceAEADCipherImpl.checkForAEAD();
    private final JcaJceHelper helper;
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private final int keySize;
    private final String algorithmParamsName;
    private SecretKey key;

    private static boolean checkForAEAD() {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Cipher.class.getMethod("updateAAD", byte[].class) != null;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        });
    }

    private static String getAlgParamsName(JcaJceHelper jcaJceHelper, String string) {
        try {
            String string2 = string.contains("CCM") ? "CCM" : "GCM";
            jcaJceHelper.createAlgorithmParameters(string2);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JceAEADCipherImpl(JcaJceHelper jcaJceHelper, String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        this.helper = jcaJceHelper;
        this.cipher = jcaJceHelper.createCipher(string);
        this.algorithm = string2;
        this.keySize = n;
        this.cipherMode = bl ? 1 : 2;
        this.algorithmParamsName = JceAEADCipherImpl.getAlgParamsName(jcaJceHelper, string);
    }

    public void setKey(byte[] byArray, int n, int n2) {
        if (this.keySize != n2) {
            throw new IllegalStateException();
        }
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    public void init(byte[] byArray, int n) {
        try {
            if (canDoAEAD && this.algorithmParamsName != null) {
                AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters(this.algorithmParamsName);
                if (GCMUtil.isGCMParameterSpecAvailable()) {
                    algorithmParameters.init(GCMUtil.createGCMParameterSpec(n * 8, byArray));
                } else {
                    algorithmParameters.init(new GCMParameters(byArray, n).getEncoded());
                }
                this.cipher.init(this.cipherMode, (Key)this.key, algorithmParameters, null);
            } else {
                this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)new AEADParameterSpec(byArray, n * 8, null), null);
            }
        }
        catch (Exception exception) {
            throw Exceptions.illegalStateException(exception.getMessage(), exception);
        }
    }

    public int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    public int doFinal(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) throws IOException {
        if (!Arrays.isNullOrEmpty((byte[])byArray)) {
            this.cipher.updateAAD(byArray);
        }
        try {
            return this.cipher.doFinal(byArray2, n, n2, byArray3, n3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("", generalSecurityException);
        }
    }
}

