/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AbstractAlgorithmConstraints;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Logger LOG = Logger.getLogger(DisabledAlgorithmConstraints.class.getName());
    private static final String INCLUDE_PREFIX = "include ";
    private static final String KEYWORD_KEYSIZE = "keySize";
    private final Set<String> disabledAlgorithms;
    private final Map<String, List<Constraint>> constraintsMap;

    static DisabledAlgorithmConstraints create(AlgorithmDecomposer algorithmDecomposer, String string, String string2) {
        String[] stringArray = PropertyUtils.getStringArraySecurityProperty(string, string2);
        if (null == stringArray) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, List<Constraint>> hashMap = new HashMap<String, List<Constraint>>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (DisabledAlgorithmConstraints.addConstraint(hashSet, hashMap, stringArray[i])) continue;
            LOG.warning("Ignoring unsupported entry in '" + string + "': " + stringArray[i]);
        }
        return new DisabledAlgorithmConstraints(algorithmDecomposer, Collections.unmodifiableSet(hashSet), Collections.unmodifiableMap(hashMap));
    }

    private static boolean addConstraint(Set<String> set, Map<String, List<Constraint>> map, String string) {
        if (string.regionMatches(true, 0, INCLUDE_PREFIX, 0, INCLUDE_PREFIX.length())) {
            return false;
        }
        int n = string.indexOf(32);
        if (n < 0) {
            String string2 = DisabledAlgorithmConstraints.getCanonicalAlgorithm(string);
            set.add(string2);
            DisabledAlgorithmConstraints.addConstraint(map, string2, DisabledConstraint.INSTANCE);
            return true;
        }
        String string3 = DisabledAlgorithmConstraints.getCanonicalAlgorithm(string.substring(0, n));
        String string4 = string.substring(n + 1).trim();
        int n2 = string4.indexOf(38);
        if (n2 >= 0) {
            return false;
        }
        if (string4.startsWith(KEYWORD_KEYSIZE)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            if (!KEYWORD_KEYSIZE.equals(stringTokenizer.nextToken())) {
                return false;
            }
            BinOp binOp = BinOp.parse(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                return false;
            }
            DisabledAlgorithmConstraints.addConstraint(map, string3, new KeySizeConstraint(binOp, n3));
            return true;
        }
        return false;
    }

    private static void addConstraint(Map<String, List<Constraint>> map, String string, Constraint constraint) {
        List<Constraint> list = map.get(string);
        if (null == list) {
            list = new ArrayList<Constraint>(1);
            map.put(string, list);
        }
        list.add(constraint);
    }

    private static String getCanonicalAlgorithm(String string) {
        if ("DiffieHellman".equalsIgnoreCase(string)) {
            return "DH";
        }
        return string.toUpperCase(Locale.ENGLISH).replace("SHA-", "SHA");
    }

    private static String getConstraintsAlgorithm(String string, AlgorithmParameters algorithmParameters) {
        String string2;
        String string3;
        if (null != algorithmParameters && null != (string3 = algorithmParameters.getAlgorithm()) && (string2 = DisabledAlgorithmConstraints.getCanonicalAlgorithm(string)).equalsIgnoreCase(DisabledAlgorithmConstraints.getCanonicalAlgorithm(string3))) {
            return string2;
        }
        return null;
    }

    private static String getConstraintsAlgorithm(Key key) {
        String string;
        if (null != key && null != (string = JsseUtils.getKeyAlgorithm(key))) {
            return DisabledAlgorithmConstraints.getCanonicalAlgorithm(string);
        }
        return null;
    }

    private DisabledAlgorithmConstraints(AlgorithmDecomposer algorithmDecomposer, Set<String> set, Map<String, List<Constraint>> map) {
        super(algorithmDecomposer);
        this.disabledAlgorithms = set;
        this.constraintsMap = map;
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        this.checkPrimitives(set);
        this.checkAlgorithmName(string);
        if (this.containsAnyPartIgnoreCase(this.disabledAlgorithms, string)) {
            return false;
        }
        for (Constraint constraint : this.getConstraints(DisabledAlgorithmConstraints.getConstraintsAlgorithm(string, algorithmParameters))) {
            if (constraint.permits(algorithmParameters)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, null, key, null);
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        this.checkAlgorithmName(string);
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    private boolean checkConstraints(Set<BCCryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        this.checkPrimitives(set);
        this.checkKey(key);
        if (JsseUtils.isNameSpecified(string) && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, JsseUtils.getKeyAlgorithm(key), null)) {
            return false;
        }
        for (Constraint constraint : this.getConstraints(DisabledAlgorithmConstraints.getConstraintsAlgorithm(key))) {
            if (constraint.permits(key)) continue;
            return false;
        }
        return true;
    }

    private List<Constraint> getConstraints(String string) {
        List<Constraint> list;
        if (null != string && null != (list = this.constraintsMap.get(string))) {
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BinOp {
        EQ("=="),
        GE(">="),
        GT(">"),
        LE("<="),
        LT("<"),
        NE("!=");

        private final String s;

        static boolean eval(BinOp binOp, int n, int n2) {
            switch (binOp) {
                case EQ: {
                    return n == n2;
                }
                case GE: {
                    return n >= n2;
                }
                case GT: {
                    return n > n2;
                }
                case LE: {
                    return n <= n2;
                }
                case LT: {
                    return n < n2;
                }
                case NE: {
                    return n != n2;
                }
            }
            return true;
        }

        static BinOp parse(String string) {
            for (BinOp binOp : BinOp.values()) {
                if (!binOp.s.equals(string)) continue;
                return binOp;
            }
            throw new IllegalArgumentException("'s' is not a valid operator: " + string);
        }

        private BinOp(String string2) {
            this.s = string2;
        }
    }

    private static abstract class Constraint {
        private Constraint() {
        }

        boolean permits(AlgorithmParameters algorithmParameters) {
            return true;
        }

        boolean permits(Key key) {
            return true;
        }
    }

    private static class DisabledConstraint
    extends Constraint {
        static final DisabledConstraint INSTANCE = new DisabledConstraint();

        private DisabledConstraint() {
        }

        public boolean permits(Key key) {
            return false;
        }
    }

    private static class KeySizeConstraint
    extends Constraint {
        private final BinOp op;
        private final int constraint;

        private static int getKeySize(AlgorithmParameters algorithmParameters) {
            String string = algorithmParameters.getAlgorithm();
            if ("EC".equals(string)) {
                try {
                    ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                    if (null != eCParameterSpec) {
                        return eCParameterSpec.getOrder().bitLength();
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {}
            } else if ("DiffieHellman".equals(string)) {
                try {
                    DHParameterSpec dHParameterSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
                    if (null != dHParameterSpec) {
                        return dHParameterSpec.getP().bitLength();
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
            }
            return -1;
        }

        private static int getKeySize(Key key) {
            if (key instanceof RSAKey) {
                RSAKey rSAKey = (RSAKey)((Object)key);
                return rSAKey.getModulus().bitLength();
            }
            if (key instanceof ECKey) {
                ECKey eCKey = (ECKey)((Object)key);
                return eCKey.getParams().getOrder().bitLength();
            }
            if (key instanceof DSAKey) {
                DSAKey dSAKey = (DSAKey)((Object)key);
                DSAParams dSAParams = dSAKey.getParams();
                if (null != dSAParams) {
                    return dSAParams.getP().bitLength();
                }
            } else {
                byte[] byArray;
                SecretKey secretKey;
                String string;
                if (key instanceof DHKey) {
                    DHKey dHKey = (DHKey)((Object)key);
                    return dHKey.getParams().getP().bitLength();
                }
                if (key instanceof SecretKey && "RAW".equals(string = (secretKey = (SecretKey)key).getFormat()) && null != (byArray = secretKey.getEncoded())) {
                    int n = byArray.length;
                    return n > 0xFFFFFFF ? 0 : 8 * byArray.length;
                }
            }
            return -1;
        }

        KeySizeConstraint(BinOp binOp, int n) {
            this.op = binOp;
            this.constraint = n;
        }

        boolean permits(AlgorithmParameters algorithmParameters) {
            return this.checkKeySize(KeySizeConstraint.getKeySize(algorithmParameters));
        }

        boolean permits(Key key) {
            return this.checkKeySize(KeySizeConstraint.getKeySize(key));
        }

        private boolean checkKeySize(int n) {
            if (n < 1) {
                return n < 0;
            }
            return !BinOp.eval(this.op, n, this.constraint);
        }
    }
}

