/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.maven.plugin.processor.ZipFileObject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationProcessorMojo
extends AbstractMojo {
    private static final String SOURCE_CLASSIFIER = "sources";
    @Component
    protected MavenProject project;
    @Parameter(property="plugin.artifacts", readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter
    private File outputDirectory;
    @Parameter
    private String[] processors;
    @Parameter
    private String compilerArguments;
    @Parameter(alias="options")
    private Map<String, Object> optionMap;
    @Parameter
    private Boolean addOutputDirectoryToCompilationSources;
    @Parameter(defaultValue="true", required=true, property="annotation.failOnError")
    private Boolean failOnError = true;
    @Parameter(defaultValue="true", required=true, property="annotation.outputDiagnostics")
    private boolean outputDiagnostics = true;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter
    private List<File> additionalSourceDirectories;
    @Parameter(defaultValue="false")
    private boolean addCompileSourceRoots = false;
    @Parameter(defaultValue="false")
    private boolean appendSourceArtifacts = false;
    @Parameter(property="project.build.sourceEncoding")
    private String encoding;
    private static final Lock syncExecutionLock = new ReentrantLock();

    protected abstract Set<File> getSourceDirectories(Set<File> var1);

    protected abstract File getOutputClassDirectory();

    protected abstract void addCompileSourceRoot(MavenProject var1, String var2);

    public abstract File getDefaultOutputDirectory();

    private String buildProcessor() {
        int i;
        if (this.processors == null || this.processors.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < this.processors.length - 1; ++i) {
            result.append(this.processors[i]).append(',');
        }
        result.append(this.processors[i]);
        return result.toString();
    }

    protected abstract Set<String> getClasspathElements(Set<String> var1);

    private String buildCompileClasspath() {
        LinkedHashSet<String> pathElements = new LinkedHashSet<String>();
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                File f;
                if (!"compile".equalsIgnoreCase(a.getScope()) && !"runtime".equalsIgnoreCase(a.getScope()) || (f = a.getFile()) == null) continue;
                pathElements.add(a.getFile().getAbsolutePath());
            }
        }
        this.getClasspathElements(pathElements);
        StringBuilder result = new StringBuilder();
        for (String elem : pathElements) {
            result.append(elem).append(File.pathSeparator);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            return;
        }
        syncExecutionLock.lock();
        try {
            this.executeWithExceptionsHandled();
        }
        catch (Exception e1) {
            super.getLog().error((CharSequence)("error on execute: " + e1.getMessage()));
            if (this.failOnError.booleanValue()) {
                throw new MojoExecutionException("Error executing", e1);
            }
        }
        finally {
            syncExecutionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithExceptionsHandled() throws Exception {
        List sourceRoots;
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getDefaultOutputDirectory();
        }
        this.ensureOutputDirectoryExists();
        this.addOutputToSourcesIfNeeded();
        String includesString = this.includes == null || this.includes.length == 0 ? "**/*.java" : StringUtils.join((Object[])this.includes, (String)",");
        String excludesString = this.excludes == null || this.excludes.length == 0 ? null : StringUtils.join((Object[])this.excludes, (String)",");
        Set<File> sourceDirs = this.getSourceDirectories(new HashSet<File>(5));
        if (this.addCompileSourceRoots && (sourceRoots = this.project.getCompileSourceRoots()) != null) {
            for (String s : sourceRoots) {
                sourceDirs.add(new File(s));
            }
        }
        if (this.additionalSourceDirectories != null && !this.additionalSourceDirectories.isEmpty()) {
            sourceDirs.addAll(this.additionalSourceDirectories);
        }
        if (sourceDirs == null) {
            throw new IllegalStateException("getSourceDirectories is null!");
        }
        ArrayList files = new ArrayList();
        for (File sourceDir : sourceDirs) {
            if (sourceDir == null) {
                this.getLog().warn((CharSequence)"source directory is null! Processor task will be skipped!");
                continue;
            }
            this.getLog().debug((CharSequence)String.format("processing source directory [%s]", sourceDir.getPath()));
            if (!sourceDir.exists()) {
                this.getLog().warn((CharSequence)String.format("source directory [%s] doesn't exist! Processor task will be skipped!", sourceDir.getPath()));
                continue;
            }
            if (!sourceDir.isDirectory()) {
                this.getLog().warn((CharSequence)String.format("source directory [%s] is invalid! Processor task will be skipped!", sourceDir.getPath()));
                continue;
            }
            files.addAll(FileUtils.getFiles((File)sourceDir, (String)includesString, (String)excludesString));
        }
        String compileClassPath = this.buildCompileClasspath();
        String processor = this.buildProcessor();
        ArrayList<String> options = new ArrayList<String>(10);
        options.add("-cp");
        options.add(compileClassPath);
        options.add("-proc:only");
        this.addCompilerArguments(options);
        if (processor != null) {
            options.add("-processor");
            options.add(processor);
        } else {
            this.getLog().warn((CharSequence)"No processors specified. Using default discovery mechanism.");
        }
        options.add("-d");
        options.add(this.getOutputClassDirectory().getPath());
        options.add("-s");
        options.add(this.outputDirectory.getPath());
        if (this.getLog().isDebugEnabled()) {
            for (String option : options) {
                this.getLog().debug((CharSequence)String.format("javac option: %s", option));
            }
        }
        DiagnosticListener<JavaFileObject> dl = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (!AbstractAnnotationProcessorMojo.this.outputDiagnostics) {
                    return;
                }
                Diagnostic.Kind kind = diagnostic.getKind();
                if (Diagnostic.Kind.ERROR == kind) {
                    AbstractAnnotationProcessorMojo.this.getLog().error((CharSequence)String.format("diagnostic: %s", diagnostic));
                } else if (Diagnostic.Kind.MANDATORY_WARNING == kind || Diagnostic.Kind.WARNING == kind) {
                    AbstractAnnotationProcessorMojo.this.getLog().warn((CharSequence)String.format("diagnostic: %s", diagnostic));
                } else if (Diagnostic.Kind.NOTE == kind) {
                    AbstractAnnotationProcessorMojo.this.getLog().debug((CharSequence)String.format("diagnostic: %s", diagnostic));
                } else if (Diagnostic.Kind.OTHER == kind) {
                    AbstractAnnotationProcessorMojo.this.getLog().info((CharSequence)String.format("diagnostic: %s", diagnostic));
                }
            }
        };
        if (this.systemProperties != null) {
            Set<Map.Entry<String, String>> pSet = this.systemProperties.entrySet();
            for (Map.Entry<String, String> e : pSet) {
                this.getLog().debug((CharSequence)String.format("set system property : [%s] = [%s]", e.getKey(), e.getValue()));
                System.setProperty(e.getKey(), e.getValue());
            }
        }
        final ArrayList<JavaFileObject> allSources = new ArrayList<JavaFileObject>();
        this.processSourceArtifacts(new ArtifactClosure(){

            public void execute(Artifact artifact) {
                try {
                    File f = artifact.getFile();
                    ZipFile zipFile = new ZipFile(f);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    int sourceCount = 0;
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".java")) continue;
                        ++sourceCount;
                        allSources.add(ZipFileObject.create(zipFile, entry));
                    }
                    AbstractAnnotationProcessorMojo.this.getLog().debug((CharSequence)String.format("** Discovered %d java sources in %s", sourceCount, f.getAbsolutePath()));
                }
                catch (Exception ex) {
                    AbstractAnnotationProcessorMojo.this.getLog().warn((CharSequence)String.format("Problem reading source archive [%s]", artifact.getFile().getPath()));
                }
            }
        });
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            this.getLog().error((CharSequence)"JVM is not suitable for processing annotation! ToolProvider.getSystemJavaCompiler() is null.");
            return;
        }
        Charset charset = null;
        if (this.encoding != null) {
            try {
                charset = Charset.forName(this.encoding);
            }
            catch (IllegalCharsetNameException ex1) {
                this.getLog().warn((CharSequence)String.format("the given charset name [%s] is illegal!. default is used", this.encoding));
                charset = null;
            }
            catch (UnsupportedCharsetException ex2) {
                this.getLog().warn((CharSequence)String.format("the given charset name [%s] is unsupported!. default is used", this.encoding));
                charset = null;
            }
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, charset == null ? Charset.defaultCharset() : charset);
        if (files != null && !files.isEmpty()) {
            for (JavaFileObject javaFileObject : fileManager.getJavaFileObjectsFromFiles(files)) {
                allSources.add(javaFileObject);
            }
        }
        if (allSources.isEmpty()) {
            this.getLog().warn((CharSequence)"no source file(s) detected! Processor task will be skipped");
            return;
        }
        Iterable<String> classes = null;
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(new PrintWriter(System.out), fileManager, (DiagnosticListener<? super JavaFileObject>)dl, options, classes, allSources);
        if (!compilationTask.call().booleanValue()) {
            throw new Exception("error during compilation");
        }
    }

    private List<File> scanSourceDirectorySources(File sourceDir) throws IOException {
        if (sourceDir == null) {
            this.getLog().warn((CharSequence)"source directory cannot be read (null returned)! Processor task will be skipped");
            return null;
        }
        if (!sourceDir.exists()) {
            this.getLog().warn((CharSequence)"source directory doesn't exist! Processor task will be skipped");
            return null;
        }
        if (!sourceDir.isDirectory()) {
            this.getLog().warn((CharSequence)"source directory is invalid! Processor task will be skipped");
            return null;
        }
        String includesString = this.includes == null || this.includes.length == 0 ? "**/*.java" : StringUtils.join((Object[])this.includes, (String)",");
        String excludesString = this.excludes == null || this.excludes.length == 0 ? null : StringUtils.join((Object[])this.excludes, (String)",");
        List files = FileUtils.getFiles((File)sourceDir, (String)includesString, excludesString);
        return files;
    }

    private void addCompilerArguments(List<String> options) {
        if (!StringUtils.isEmpty((String)this.compilerArguments)) {
            for (String arg : this.compilerArguments.split(" ")) {
                if (StringUtils.isEmpty((String)arg)) continue;
                arg = arg.trim();
                this.getLog().debug((CharSequence)String.format("Adding compiler arg: %s", arg));
                options.add(arg);
            }
        }
        if (this.optionMap != null && !this.optionMap.isEmpty()) {
            for (Map.Entry<String, Object> e : this.optionMap.entrySet()) {
                if (StringUtils.isEmpty((String)e.getKey()) || e.getValue() == null) continue;
                String opt = String.format("-A%s=%s", e.getKey().trim(), e.getValue().toString().trim());
                options.add(opt);
                this.getLog().debug((CharSequence)String.format("Adding compiler arg: %s", opt));
            }
        }
    }

    private void addOutputToSourcesIfNeeded() {
        Boolean add = this.addOutputDirectoryToCompilationSources;
        if (add == null || add.booleanValue()) {
            this.getLog().debug((CharSequence)String.format("Source directory: %s added", this.outputDirectory));
            this.addCompileSourceRoot(this.project, this.outputDirectory.getAbsolutePath());
        }
    }

    private void ensureOutputDirectoryExists() {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!this.getOutputClassDirectory().exists()) {
            this.getOutputClassDirectory().mkdirs();
        }
    }

    private void processSourceArtifacts(ArtifactClosure closure) {
        if (!this.appendSourceArtifacts) {
            return;
        }
        for (Artifact dep : this.project.getDependencyArtifacts()) {
            if (!dep.hasClassifier() || !dep.getClassifier().equals(SOURCE_CLASSIFIER)) continue;
            closure.execute(dep);
        }
    }

    static interface ArtifactClosure {
        public void execute(Artifact var1);
    }
}

