// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_cudacodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

import static org.bytedeco.opencv.global.opencv_cudacodec.*;


/** \brief Interface for video demultiplexing. :
<p>
User can implement own demultiplexing by implementing this interface.
 */
@Namespace("cv::cudacodec") @Properties(inherit = org.bytedeco.opencv.presets.opencv_cudacodec.class)
public class RawVideoSource extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RawVideoSource(Pointer p) { super(p); }


    /** \brief Returns next packet with RAW video frame.
    <p>
    @param data Pointer to frame data.
    @param size Size in bytes of current frame.
     */
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") PointerPointer data, @Cast("size_t*") SizeTPointer size);
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") @ByPtrPtr BytePointer data, @Cast("size_t*") SizeTPointer size);
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") @ByPtrPtr ByteBuffer data, @Cast("size_t*") SizeTPointer size);
    public native @Cast("bool") boolean getNextPacket(@Cast("unsigned char**") @ByPtrPtr byte[] data, @Cast("size_t*") SizeTPointer size);

    /** \brief Returns information about video file format.
    */
    public native @ByVal FormatInfo format();
}
