/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.xmlConfiguration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.ConfigurationWithSections;
import org.cache2k.configuration.CustomizationSupplierByClassName;
import org.cache2k.configuration.SingletonConfigurationSection;
import org.cache2k.core.spi.CacheConfigurationProvider;
import org.cache2k.xmlConfiguration.BeanPropertyMutator;
import org.cache2k.xmlConfiguration.ConfigurationContext;
import org.cache2k.xmlConfiguration.ConfigurationException;
import org.cache2k.xmlConfiguration.ConfigurationParser;
import org.cache2k.xmlConfiguration.ConfigurationTokenizer;
import org.cache2k.xmlConfiguration.FlexibleXmlTokenizerFactory;
import org.cache2k.xmlConfiguration.ParsedConfiguration;
import org.cache2k.xmlConfiguration.PropertyParser;
import org.cache2k.xmlConfiguration.SourceLocation;
import org.cache2k.xmlConfiguration.StandardPropertyParser;
import org.cache2k.xmlConfiguration.StandardVariableExpander;
import org.cache2k.xmlConfiguration.TokenizerFactory;

public class CacheConfigurationProviderImpl
implements CacheConfigurationProvider {
    private static final String DEFAULT_CONFIGURATION_FILE = "cache2k.xml";
    private static final Map<String, String> version1SectionTypes = new HashMap<String, String>(){
        {
            this.put("jcache", "org.cache2k.jcache.JCacheConfiguration");
            this.put("byClassName", CustomizationSupplierByClassName.class.getName());
        }
    };
    private PropertyParser propertyParser = new StandardPropertyParser();
    private TokenizerFactory tokenizerFactory = new FlexibleXmlTokenizerFactory();
    private volatile Map<Class<?>, BeanPropertyMutator> type2mutator = new HashMap();
    private volatile ConfigurationContext defaultManagerContext = null;
    private volatile Map<CacheManager, ConfigurationContext> manager2defaultConfig = new HashMap<CacheManager, ConfigurationContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultManagerName(ClassLoader cl) {
        CacheConfigurationProviderImpl cacheConfigurationProviderImpl = this;
        synchronized (cacheConfigurationProviderImpl) {
            this.defaultManagerContext = this.createContext(cl, null, DEFAULT_CONFIGURATION_FILE);
        }
        return this.defaultManagerContext.getDefaultManagerName();
    }

    @Override
    public Cache2kConfiguration getDefaultConfiguration(CacheManager mgr) {
        Cache2kConfiguration<?, ?> cfg = this.getManagerContext(mgr).getDefaultManagerConfiguration();
        return CacheConfigurationProviderImpl.copyViaSerialization(mgr, cfg);
    }

    @Override
    public <K, V> void augmentConfiguration(CacheManager mgr, Cache2kConfiguration<K, V> cfg) {
        ConfigurationContext ctx = this.getManagerContext(mgr);
        if (!ctx.isConfigurationPresent()) {
            return;
        }
        String _cacheName = cfg.getName();
        if (_cacheName == null) {
            if (ctx.isIgnoreAnonymousCache()) {
                return;
            }
            throw new ConfigurationException("Cache name missing, cannot apply XML configuration. Consider parameter: ignoreAnonymousCache");
        }
        ParsedConfiguration _parsedTop = this.readManagerConfigurationWithExceptionHandling(mgr.getClassLoader(), CacheConfigurationProviderImpl.getFileName(mgr));
        ParsedConfiguration _parsedCache = null;
        ParsedConfiguration _section = this.extractCachesSection(_parsedTop);
        if (_section != null) {
            _parsedCache = _section.getSection(_cacheName);
        }
        if (_parsedCache == null) {
            if (ctx.isIgnoreMissingCacheConfiguration()) {
                return;
            }
            String _exceptionText = "Configuration for cache '" + _cacheName + "' is missing. Consider parameter: ignoreMissingCacheConfiguration";
            throw new ConfigurationException(_exceptionText, _parsedTop.getSource());
        }
        this.apply(ctx, _parsedCache, cfg);
        cfg.setExternalConfigurationPresent(true);
    }

    private static String getFileName(CacheManager mgr) {
        if (mgr.isDefaultManager()) {
            return DEFAULT_CONFIGURATION_FILE;
        }
        return "cache2k-" + mgr.getName() + ".xml";
    }

    private ParsedConfiguration readManagerConfiguration(ClassLoader cl, String _fileName) throws Exception {
        InputStream is = cl.getResourceAsStream(_fileName);
        if (is == null) {
            return null;
        }
        ConfigurationTokenizer tkn = this.tokenizerFactory.createTokenizer(_fileName, is, null);
        ParsedConfiguration cfg = ConfigurationParser.parse(tkn);
        StandardVariableExpander _expander = new StandardVariableExpander();
        _expander.expand(cfg);
        return cfg;
    }

    private ParsedConfiguration extractCachesSection(ParsedConfiguration pc) {
        ParsedConfiguration _cachesSection = pc.getSection("caches");
        if (_cachesSection == null) {
            return null;
        }
        return _cachesSection;
    }

    private void checkCacheConfigurationOnStartup(ConfigurationContext ctx, ParsedConfiguration pc) {
        ParsedConfiguration _cachesSection = pc.getSection("caches");
        if (_cachesSection == null) {
            return;
        }
        for (ParsedConfiguration _cacheConfig : _cachesSection.getSections()) {
            this.apply(ctx, _cacheConfig, new Cache2kConfiguration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationContext getManagerContext(CacheManager mgr) {
        ConfigurationContext ctx = this.manager2defaultConfig.get(mgr);
        if (ctx != null) {
            return ctx;
        }
        CacheConfigurationProviderImpl cacheConfigurationProviderImpl = this;
        synchronized (cacheConfigurationProviderImpl) {
            ctx = mgr.isDefaultManager() && this.defaultManagerContext != null ? this.defaultManagerContext : this.createContext(mgr.getClassLoader(), mgr.getName(), CacheConfigurationProviderImpl.getFileName(mgr));
            HashMap<CacheManager, ConfigurationContext> m2 = new HashMap<CacheManager, ConfigurationContext>(this.manager2defaultConfig);
            m2.put(mgr, ctx);
            this.manager2defaultConfig = m2;
            return ctx;
        }
    }

    private ConfigurationContext createContext(ClassLoader cl, String _managerName, String _fileName_fileName) {
        ParsedConfiguration pc = this.readManagerConfigurationWithExceptionHandling(cl, _fileName_fileName);
        ConfigurationContext ctx = new ConfigurationContext();
        ctx.setClassLoader(cl);
        Cache2kConfiguration _defaultConfiguration = new Cache2kConfiguration();
        ctx.setDefaultManagerConfiguration(_defaultConfiguration);
        ctx.setDefaultManagerName(_managerName);
        if (pc != null) {
            ctx.setTemplates(this.extractTemplates(pc));
            this.apply(ctx, pc, ctx);
            if (ctx.getVersion() != null && ctx.getVersion().startsWith("1.")) {
                ctx.setPredefinedSectionTypes(version1SectionTypes);
            }
            this.applyDefaultConfigurationIfPresent(ctx, pc, _defaultConfiguration);
            ctx.setConfigurationPresent(true);
            if (!ctx.isSkipCheckOnStartup()) {
                this.checkCacheConfigurationOnStartup(ctx, pc);
            }
        }
        return ctx;
    }

    private ParsedConfiguration readManagerConfigurationWithExceptionHandling(ClassLoader cl, String _fileName) {
        ParsedConfiguration pc;
        try {
            pc = this.readManagerConfiguration(cl, _fileName);
        }
        catch (CacheException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Reading configuration for manager from '" + _fileName + "'", ex);
        }
        return pc;
    }

    private void applyDefaultConfigurationIfPresent(ConfigurationContext ctx, ParsedConfiguration _pc, Cache2kConfiguration _defaultConfiguration) {
        ParsedConfiguration _defaults = _pc.getSection("defaults");
        if (_defaults != null) {
            _defaults = _defaults.getSection("cache");
        }
        if (_defaults != null) {
            this.apply(ctx, _defaults, _defaultConfiguration);
        }
    }

    private static <T extends Serializable> T copyViaSerialization(CacheManager mgr, T obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            return (T)((Serializable)new ObjectInputStream(bin).readObject());
        }
        catch (Exception ex) {
            throw new ConfigurationException("Copying default cache configuration for manager '" + mgr.getName() + "'", ex);
        }
    }

    void apply(ConfigurationContext ctx, ParsedConfiguration _parsedCfg, Object cfg) {
        ParsedConfiguration _templates = ctx.getTemplates();
        ConfigurationTokenizer.Property _include = _parsedCfg.getPropertyMap().get("include");
        if (_include != null) {
            for (String _template : _include.getValue().split(",")) {
                ParsedConfiguration c2 = null;
                if (_templates != null) {
                    c2 = _templates.getSection(_template);
                }
                if (c2 == null) {
                    throw new ConfigurationException("Template not found '" + _template + "'", _include);
                }
                this.apply(ctx, c2, cfg);
            }
        }
        this.applyPropertyValues(_parsedCfg, cfg);
        if (!(cfg instanceof ConfigurationWithSections)) {
            return;
        }
        ConfigurationWithSections _configurationWithSections = (ConfigurationWithSections)cfg;
        for (ParsedConfiguration _parsedSection : _parsedCfg.getSections()) {
            Class<?> _type;
            String _sectionType = ctx.getPredefinedSectionTypes().get(_parsedSection.getName());
            if (_sectionType == null) {
                _sectionType = _parsedSection.getType();
            }
            if (_sectionType == null) {
                throw new ConfigurationException("type missing or unknown", _parsedSection);
            }
            try {
                _type = Class.forName(_sectionType);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("class not found '" + _sectionType + "'", _parsedSection);
            }
            if (this.handleSection(ctx, _type, _configurationWithSections, _parsedSection) || this.handleBean(ctx, _type, cfg, _parsedSection) || this.handleCollection(ctx, _type, cfg, _parsedSection)) continue;
            throw new ConfigurationException("Unknown property  '" + _parsedSection.getContainer() + "'", _parsedSection);
        }
    }

    private boolean handleBean(ConfigurationContext ctx, Class<?> _type, Object cfg, ParsedConfiguration _parsedCfg) {
        String _containerName = _parsedCfg.getContainer();
        BeanPropertyMutator m = this.provideMutator(cfg.getClass());
        Class<?> _targetType = m.getType(_containerName);
        if (_targetType == null) {
            return false;
        }
        if (!_targetType.isAssignableFrom(_type)) {
            throw new ConfigurationException("Type mismatch, expected: '" + _targetType.getName() + "'", _parsedCfg);
        }
        Object _bean = this.createBeanAndApplyConfiguration(ctx, _type, _parsedCfg);
        this.mutateAndCatch(cfg, m, _containerName, _bean, _parsedCfg, _bean);
        return true;
    }

    private boolean handleCollection(ConfigurationContext ctx, Class<?> _type, Object cfg, ParsedConfiguration _parsedCfg) {
        Collection c;
        Method m;
        String _containerName = _parsedCfg.getContainer();
        try {
            m = cfg.getClass().getMethod(CacheConfigurationProviderImpl.constructGetterName(_containerName), new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        if (!Collection.class.isAssignableFrom(m.getReturnType())) {
            return false;
        }
        try {
            c = (Collection)m.invoke(cfg, new Object[0]);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot access collection for '" + _containerName + "' " + ex, _parsedCfg);
        }
        Object _bean = this.createBeanAndApplyConfiguration(ctx, _type, _parsedCfg);
        try {
            c.add(_bean);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Rejected add '" + _containerName + "': " + ex.getMessage(), _parsedCfg);
        }
        return true;
    }

    private static String constructGetterName(String _containerName) {
        return "get" + Character.toUpperCase(_containerName.charAt(0)) + _containerName.substring(1);
    }

    private Object createBeanAndApplyConfiguration(ConfigurationContext ctx, Class<?> _type, ParsedConfiguration _parsedCfg) {
        Object _bean;
        try {
            _bean = _type.newInstance();
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot instantiate bean: " + ex, _parsedCfg);
        }
        this.apply(ctx, _parsedCfg, _bean);
        return _bean;
    }

    private boolean handleSection(ConfigurationContext ctx, Class<?> _type, ConfigurationWithSections cfg, ParsedConfiguration sc) {
        String _containerName = sc.getContainer();
        if (!"sections".equals(_containerName)) {
            return false;
        }
        Object _sectionBean = cfg.getSections().getSection(_type);
        if (_sectionBean == null || !(_sectionBean instanceof SingletonConfigurationSection)) {
            try {
                _sectionBean = (ConfigurationSection)_type.newInstance();
            }
            catch (Exception ex) {
                throw new ConfigurationException("Cannot instantiate section class: " + ex, sc);
            }
            cfg.getSections().add((ConfigurationSection)_sectionBean);
        }
        this.apply(ctx, sc, _sectionBean);
        return true;
    }

    private void applyPropertyValues(ParsedConfiguration cfg, Object _bean) {
        BeanPropertyMutator m = this.provideMutator(_bean.getClass());
        for (ConfigurationTokenizer.Property p : cfg.getPropertyMap().values()) {
            Object obj;
            Class<?> _propertyType = m.getType(p.getName());
            if (_propertyType == null) {
                if ("include".equals(p.getName()) || "name".equals(p.getName()) || "type".equals(p.getName())) continue;
                throw new ConfigurationException("Unknown property '" + p.getName() + "'", p);
            }
            try {
                obj = this.propertyParser.parse(_propertyType, p.getValue());
            }
            catch (Exception ex) {
                if (ex instanceof IllegalArgumentException) {
                    throw new ConfigurationException("Value '" + p.getValue() + "' rejected: " + ex.getMessage(), p);
                }
                throw new ConfigurationException("Cannot parse property: " + ex, p);
            }
            this.mutateAndCatch(_bean, m, p, obj);
        }
    }

    private void mutateAndCatch(Object cfg, BeanPropertyMutator m, ConfigurationTokenizer.Property p, Object obj) {
        this.mutateAndCatch(cfg, m, p.getName(), p.getValue(), p, obj);
    }

    private void mutateAndCatch(Object cfg, BeanPropertyMutator m, String _name, Object _valueForExceptionText, SourceLocation loc, Object obj) {
        try {
            m.mutate(cfg, _name, obj);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof IllegalArgumentException) {
                throw new ConfigurationException("Value '" + _valueForExceptionText + "' rejected: " + t.getMessage(), loc);
            }
            throw new ConfigurationException("Setting property: " + ex, loc);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Setting property: " + ex, loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanPropertyMutator provideMutator(Class<?> _type) {
        BeanPropertyMutator m = this.type2mutator.get(_type);
        if (m == null) {
            CacheConfigurationProviderImpl cacheConfigurationProviderImpl = this;
            synchronized (cacheConfigurationProviderImpl) {
                m = new BeanPropertyMutator(_type);
                HashMap m2 = new HashMap(this.type2mutator);
                m2.put(_type, m);
                this.type2mutator = m2;
            }
        }
        return m;
    }

    private ParsedConfiguration extractTemplates(ParsedConfiguration _pc) {
        return _pc.getSection("templates");
    }
}

