/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.citrusframework.TestCase;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestReporter;
import org.citrusframework.report.TestReporterAware;
import org.citrusframework.report.TestReporterSettings;
import org.citrusframework.report.TestResults;
import org.citrusframework.report.TestSuiteListener;

public class TestReporters
implements TestListener,
TestSuiteListener,
TestReporterAware {
    private boolean autoClear = TestReporterSettings.isAutoClear();
    private final List<TestReporter> testReporters = new ArrayList<TestReporter>();
    private TestResults testResults = new TestResults();

    @Override
    public void onStart() {
        if (this.autoClear) {
            this.testResults = new TestResults();
        }
    }

    @Override
    public void onFinishFailure(Throwable cause) {
        this.generateReports();
    }

    @Override
    public void onFinishSuccess() {
        this.generateReports();
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onStartFailure(Throwable cause) {
    }

    @Override
    public void onStartSuccess() {
    }

    @Override
    public void onTestStart(TestCase test) {
    }

    @Override
    public void onTestFinish(TestCase test) {
        if (Objects.nonNull(test.getTestResult())) {
            this.testResults.addResult(test.getTestResult());
        }
    }

    @Override
    public void onTestSuccess(TestCase test) {
    }

    @Override
    public void onTestFailure(TestCase test, Throwable cause) {
    }

    @Override
    public void onTestSkipped(TestCase test) {
    }

    @Override
    public void addTestReporter(TestReporter testReporter) {
        this.testReporters.add(testReporter);
    }

    public List<TestReporter> getTestReporters() {
        return Collections.unmodifiableList(this.testReporters);
    }

    public boolean isAutoClear() {
        return this.autoClear;
    }

    public void setAutoClear(boolean autoClear) {
        this.autoClear = autoClear;
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    private void generateReports() {
        for (TestReporter reporter : this.testReporters) {
            reporter.generateReport(this.testResults);
        }
    }
}

