/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class InputAction
extends AbstractTestAction {
    private static Logger log = LoggerFactory.getLogger(InputAction.class);
    private final String message;
    private final String variable;
    private final String validAnswers;
    private final BufferedReader inputReader;
    public static final String ANSWER_SEPARATOR = "/";

    public InputAction(Builder builder) {
        super("input", builder);
        this.message = builder.message;
        this.variable = builder.variable;
        this.validAnswers = builder.validAnswers;
        this.inputReader = Optional.ofNullable(builder.inputReader).orElse(new BufferedReader(new InputStreamReader(System.in)));
    }

    @Override
    public void doExecute(TestContext context) {
        String input;
        if (context.getVariables().containsKey(this.variable)) {
            String input2 = context.getVariable(this.variable);
            log.info("Variable " + this.variable + " is already set (='" + input2 + "'). Skip waiting for user input");
            return;
        }
        Object display = StringUtils.hasText((String)this.validAnswers) ? this.message + " (" + this.validAnswers + ")" : this.message;
        try {
            do {
                log.info((String)display);
                BufferedReader stdin = this.getInputReader();
                input = stdin.readLine();
            } while (this.validAnswers != null && !this.checkAnswer(input));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        context.setVariable(this.variable, (Object)input.trim());
    }

    protected BufferedReader getInputReader() {
        return this.inputReader;
    }

    private boolean checkAnswer(String input) {
        StringTokenizer tok = new StringTokenizer(this.validAnswers, ANSWER_SEPARATOR);
        while (tok.hasMoreTokens()) {
            if (!tok.nextElement().toString().trim().equalsIgnoreCase(input.trim())) continue;
            return true;
        }
        log.info("User input is not valid - must be one of " + this.validAnswers);
        return false;
    }

    public String getMessage() {
        return this.message;
    }

    public String getVariable() {
        return this.variable;
    }

    public String getValidAnswers() {
        return this.validAnswers;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<InputAction, Builder> {
        private String message = "Press return key to continue ...";
        private String variable = "userinput";
        private String validAnswers;
        private BufferedReader inputReader;

        public static Builder input() {
            return new Builder();
        }

        public static Builder input(String message) {
            Builder builder = new Builder();
            builder.message(message);
            return builder;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder result(String variable) {
            this.variable = variable;
            return this;
        }

        public Builder reader(BufferedReader reader) {
            this.inputReader = reader;
            return this;
        }

        public Builder answers(String ... answers) {
            if (answers.length == 0) {
                throw new CitrusRuntimeException("Please specify proper answer possibilities for input action");
            }
            StringJoiner joiner = new StringJoiner(InputAction.ANSWER_SEPARATOR);
            Stream.of(answers).forEach(joiner::add);
            this.validAnswers = joiner.toString();
            return this;
        }

        public InputAction build() {
            return new InputAction(this);
        }
    }
}

