/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class LoadPropertiesAction
extends AbstractTestAction {
    private final String filePath;
    private static final Logger LOG = LoggerFactory.getLogger(LoadPropertiesAction.class);

    public LoadPropertiesAction(Builder builder) {
        super("load", builder);
        this.filePath = builder.filePath;
    }

    @Override
    public void doExecute(TestContext context) {
        Resource resource = FileUtils.getFileResource(this.filePath, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading property file " + resource.getFilename());
        }
        Properties props = FileUtils.loadAsProperties(resource);
        LinkedHashMap<String, String> unresolved = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading property: " + key + "=" + props.getProperty(key) + " into variables");
            }
            if (LOG.isDebugEnabled() && context.getVariables().containsKey(key)) {
                LOG.debug("Overwriting property " + key + " old value:" + context.getVariable(key) + " new value:" + props.getProperty(key));
            }
            try {
                context.setVariable(key, (Object)context.replaceDynamicContentInString(props.getProperty(key)));
            }
            catch (CitrusRuntimeException e) {
                unresolved.put(key, props.getProperty(key));
            }
        }
        context.resolveDynamicValuesInMap(unresolved).forEach((arg_0, arg_1) -> ((TestContext)context).setVariable(arg_0, arg_1));
        LOG.info("Loaded property file " + resource.getFilename());
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<LoadPropertiesAction, Builder> {
        private String filePath;

        public static Builder load(String filePath) {
            Builder builder = new Builder();
            builder.filePath(filePath);
            return builder;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public LoadPropertiesAction build() {
            return new LoadPropertiesAction(this);
        }
    }
}

