/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopServerAction
extends AbstractTestAction {
    private final List<Server> servers;
    private static Logger log = LoggerFactory.getLogger(StopServerAction.class);

    public StopServerAction(Builder builder) {
        super("stop-server", builder);
        this.servers = builder.servers;
    }

    @Override
    public void doExecute(TestContext context) {
        for (Server server : this.servers) {
            server.stop();
            log.info("Stopped server: " + server.getName());
        }
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<StopServerAction, Builder> {
        private List<Server> servers = new ArrayList<Server>();

        public static Builder stop(Server ... servers) {
            Builder builder = new Builder();
            Stream.of(servers).forEach(xva$0 -> builder.server((Server)xva$0));
            return builder;
        }

        public static Builder stop(Server server) {
            Builder builder = new Builder();
            builder.server(server);
            return builder;
        }

        public Builder server(Server ... server) {
            return this.server(Arrays.asList(server));
        }

        public Builder server(List<Server> servers) {
            this.servers.addAll(servers);
            return this;
        }

        public StopServerAction build() {
            return new StopServerAction(this);
        }
    }
}

