/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.Collection;
import org.citrusframework.AbstractTestBoundaryContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractTestBoundaryActionContainer;
import org.citrusframework.container.BeforeTest;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SequenceBeforeTest
extends AbstractTestBoundaryActionContainer
implements BeforeTest {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceBeforeTest.class);

    @Override
    public void doExecute(TestContext context) {
        if (CollectionUtils.isEmpty((Collection)this.actions)) {
            return;
        }
        LOG.info("Entering before test block");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + this.actions.size() + " actions before test");
            LOG.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            action.execute(context);
        }
    }

    public static class Builder
    extends AbstractTestBoundaryContainerBuilder<SequenceBeforeTest, Builder> {
        public static Builder beforeTest() {
            return new Builder();
        }

        @Override
        public SequenceBeforeTest doBuild() {
            return new SequenceBeforeTest();
        }
    }
}

